/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.typeconstruct;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.vjet.dsf.jstojava.resolver.ITypeConstructorResolver;

public class TypeConstructResolverExtension {
    public static final String ATT_NAME = "name";
    public static final String ATT_KEY = "key";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_CLASS = "class";
    private final String name;
    private final String key;
    private String description;
    private String executableClass;
    private final IConfigurationElement configurationElement;

    public TypeConstructResolverExtension(IConfigurationElement element) {
        this.configurationElement = element;
        this.name = this.configurationElement.getAttribute(ATT_NAME);
        Assert.isLegal((this.name != null ? 1 : 0) != 0);
        this.key = this.configurationElement.getAttribute(ATT_KEY);
        Assert.isLegal((this.key != null ? 1 : 0) != 0);
        this.executableClass = this.configurationElement.getAttribute(ATT_CLASS);
        Assert.isLegal((this.executableClass != null ? 1 : 0) != 0);
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        IConfigurationElement[] children;
        if (this.description == null && (children = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
            this.description = children[0].getValue();
        }
        return this.description;
    }

    public ITypeConstructorResolver createResolver() throws CoreException {
        ITypeConstructorResolver typeConstructResolver = (ITypeConstructorResolver)this.configurationElement.createExecutableExtension(ATT_CLASS);
        return typeConstructResolver;
    }

    public String toString() {
        String value = String.valueOf(this.name) + " [key: " + this.key + " , class: " + this.executableClass + "]";
        return value;
    }
}

