/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.internal.environment.LocalEnvironment;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.vjet.dsf.jst.ts.util.ISdkEnvironment;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.sdk.VJetSdkEnvironment;
import org.eclipse.vjet.vjo.tool.typespace.SourcePathInfo;
import org.osgi.service.prefs.BackingStoreException;

public class PiggyBackClassPathUtil {
    public static final String PREFERENCE_SCRIPTPROJECT_INITIALIZED = "initialized_project_from_v4classpath";
    private static List<String> noneVjoFileList = new ArrayList<String>();
    private static List<String> vjoFileList = new ArrayList<String>();

    public static List<URL> getProjectDependencyUrls_bak(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        URL[] urls = PiggyBackClassPathUtil.getProjectDependencyUrlsInternal(javaProject);
        ArrayList<URL> urlsString = new ArrayList<URL>(urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            urlsString.add(u);
            ++n2;
        }
        return urlsString;
    }

    private static URL[] getProjectDependencyUrlsInternal(IJavaProject javaProject) throws JavaModelException, MalformedURLException {
        ArrayList<IJavaProject> jps = new ArrayList<IJavaProject>(1);
        jps.add(javaProject);
        return PiggyBackClassPathUtil.getProjectDependencyUrls_bak(jps, null, new HashMap<String, String>());
    }

    public static URL[] getProjectDependencyUrls_bak(List<IJavaProject> javaProjectList, List<URL> currentUrlList, HashMap<String, String> projectMap) throws JavaModelException, MalformedURLException {
        List<URL> projectDependencyUrlList = currentUrlList;
        if (projectDependencyUrlList == null) {
            projectDependencyUrlList = new ArrayList<URL>();
        }
        for (IJavaProject project : javaProjectList) {
            IClasspathEntry[] entries2;
            if (projectMap.containsKey(project.getElementName())) continue;
            projectMap.put(project.getElementName(), project.getElementName());
            IClasspathEntry[] iClasspathEntryArray = entries2 = project.getRawClasspath();
            int n = entries2.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                File f = path.toFile();
                f.toURL();
                switch (entry.getEntryKind()) {
                    case 1: 
                    case 4: {
                        PiggyBackClassPathUtil.addEntryToList(entry, projectDependencyUrlList);
                    }
                    case 2: {
                        IProject subProject;
                        IJavaProject subJavaProject;
                        ArrayList<IJavaProject> subjavaProjectList = new ArrayList<IJavaProject>();
                        IResource subResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
                        if (subResource == null) {
                            entry.getPath().toString();
                            project.getElementName();
                        }
                        if (subResource == null || subResource.getType() != 4 || (subJavaProject = JavaCore.create((IProject)(subProject = (IProject)subResource))) == null || !subJavaProject.exists()) break;
                        subjavaProjectList.add(subJavaProject);
                        PiggyBackClassPathUtil.getProjectDependencyUrls_bak(subjavaProjectList, projectDependencyUrlList, projectMap);
                        break;
                    }
                    case 5: {
                        IClasspathContainer container;
                        if (JavaRuntime.JRE_CONTAINER.equals(path.toOSString()) || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project)) == null) break;
                        IClasspathEntry[] entries = container.getClasspathEntries();
                        int i = 0;
                        while (i < entries.length) {
                            PiggyBackClassPathUtil.addEntryToList(entries[i], projectDependencyUrlList);
                            ++i;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
        URL[] arrayList = new URL[projectDependencyUrlList.size()];
        URL[] returnURLArray = projectDependencyUrlList.toArray(arrayList);
        return returnURLArray;
    }

    private static void addEntryToList(IClasspathEntry entry, List<URL> projectDependencyUrlList) {
        try {
            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            if (resolvedEntry != null) {
                File f = resolvedEntry.getPath().toFile();
                if (!f.exists() || !PiggyBackClassPathUtil.isVjoJar(f)) {
                    return;
                }
                URL entryUrl = f.toURL();
                if (!projectDependencyUrlList.contains(entryUrl)) {
                    projectDependencyUrlList.add(entryUrl);
                }
            }
        }
        catch (AssertionFailedException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static IBuildpathEntry[] getResolvedBuildpath(IScriptProject vProject) {
        try {
            return vProject.getResolvedBuildpath(true);
        }
        catch (ModelException e) {
            VjetPlugin.error("Failed to get build path from <" + vProject.getElementName() + ">", e, 2);
            return new IBuildpathEntry[0];
        }
    }

    public static SourcePathInfo getProjectSrcPath_DLTK(IScriptProject vProject) {
        IBuildpathEntry[] entries;
        SourcePathInfo srcPaths = new SourcePathInfo();
        String name = vProject.getProject().getName();
        IBuildpathEntry[] iBuildpathEntryArray = entries = PiggyBackClassPathUtil.getResolvedBuildpath(vProject);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath[] iPathArray = entry.getInclusionPatterns();
                int n3 = iPathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath inclusion = iPathArray[n4];
                    srcPaths.addInclusionRule(inclusion.toPortableString());
                    ++n4;
                }
                iPathArray = entry.getExclusionPatterns();
                n3 = iPathArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IPath exclusion = iPathArray[n4];
                    srcPaths.addExclusionRule(exclusion.toPortableString());
                    ++n4;
                }
                String portableString = entry.getPath().toPortableString();
                if (portableString.lastIndexOf(name) != -1) {
                    portableString = portableString.equals(name) ? "" : portableString.substring(portableString.indexOf(name) + name.length());
                }
                srcPaths.addSourcePath(portableString);
            }
            ++n2;
        }
        return srcPaths;
    }

    public static List<URL> getProjectDependantJars_DLTK(IScriptProject vProject) {
        IBuildpathEntry[] entries = PiggyBackClassPathUtil.getResolvedBuildpath(vProject);
        ArrayList<URL> urlsString = new ArrayList<URL>(entries.length);
        int i = 0;
        while (i < entries.length) {
            URL url;
            IPath path;
            File file;
            IBuildpathEntry entry = entries[i];
            if (entry.getEntryKind() == 1 && (file = PiggyBackClassPathUtil.getFile(path = entry.getPath())) != null && file.exists() && file.isFile() && (url = PiggyBackClassPathUtil.getURL(file)) != null) {
                urlsString.add(url);
            }
            ++i;
        }
        return urlsString;
    }

    private static File getFile(IPath path) {
        File file = (path = EnvironmentPathUtils.getLocalPath((IPath)path)).toFile();
        if (!file.exists()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource member = root.findMember(path);
            if (member != null && member.exists() && member.getLocation() != null) {
                file = member.getLocation().toFile();
            } else if (member != null && member.exists() && member.getLocation() == null && member.isLinked()) {
                return null;
            }
        }
        return file;
    }

    private static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addEntryToVJETEntry(IClasspathEntry entry, List<IBuildpathEntry> vEntries, List<String> duplicateChecker) {
        try {
            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            if (resolvedEntry != null) {
                String s;
                File f = resolvedEntry.getPath().toFile();
                IFile ifile = null;
                if (!f.exists()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    ifile = workspace.getRoot().getFile(resolvedEntry.getPath());
                    if (ifile.exists()) {
                        f = ifile.getLocation().toFile();
                    }
                    if (!f.exists()) {
                        return;
                    }
                }
                if (duplicateChecker.contains(s = f.toString())) {
                    return;
                }
                duplicateChecker.add(s);
                IBuildpathEntry eEntry = null;
                if (!PiggyBackClassPathUtil.isVjoJar(f)) {
                    return;
                }
                if (ifile != null) {
                    eEntry = DLTKCore.newLibraryEntry((IPath)resolvedEntry.getPath());
                } else {
                    IEnvironment env = LocalEnvironment.getInstance();
                    eEntry = DLTKCore.newExtLibraryEntry((IPath)EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)new Path(f.toURI().toURL().getFile())));
                }
                vEntries.add(eEntry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isVjoJar(File libFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean ifScriptProjectInitializedFromJavaProject(IScriptProject vProject) {
        IProject project = vProject.getProject();
        IEclipsePreferences prefs = PiggyBackClassPathUtil.getProjectPreference(project, "org.eclipse.vjet.eclipse.core");
        if (prefs == null) {
            return false;
        }
        return prefs.getBoolean(PREFERENCE_SCRIPTPROJECT_INITIALIZED, false);
    }

    private static IEclipsePreferences getProjectPreference(IProject project, String pluginId) {
        ProjectScope projectContext = new ProjectScope(project);
        IEclipsePreferences prefs = projectContext.getNode("org.eclipse.vjet.eclipse.core");
        return prefs;
    }

    public static void initializeScriptProjectFromJavProject(IScriptProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project.getProject());
        if (!javaProject.exists()) {
            return;
        }
        List<IBuildpathEntry> vEntries = PiggyBackClassPathUtil.fetchBuildEntryFromJavaProject(javaProject);
        PiggyBackClassPathUtil.savaVJetEntries(vEntries, project);
    }

    public static List<IBuildpathEntry> fetchBuildEntryFromJavaProject(IJavaProject javaProject) {
        IClasspathEntry[] entries2;
        ArrayList<IBuildpathEntry> vEntries = new ArrayList<IBuildpathEntry>();
        ArrayList<String> duplicateChecker = new ArrayList<String>();
        try {
            entries2 = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            VjetPlugin.error("Failed to resolve Java prjoect classpath: " + javaProject.getElementName(), e, 2);
            return Collections.emptyList();
        }
        IClasspathEntry[] iClasspathEntryArray = entries2;
        int n = entries2.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IPath path = entry.getPath();
            String sPath = path.toString();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    PiggyBackClassPathUtil.addEntryToVJETEntry(entry, vEntries, duplicateChecker);
                }
                case 2: {
                    IResource subResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
                    if (subResource == null || subResource.getType() != 4) break;
                    PiggyBackClassPathUtil.addProjectEntry(entry.getPath(), vEntries, duplicateChecker);
                    break;
                }
                case 5: {
                    if (JavaRuntime.JRE_CONTAINER.equals(path.segment(0))) break;
                    try {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)javaProject);
                        if (container == null) break;
                        IClasspathEntry[] entries = container.getClasspathEntries();
                        int i = 0;
                        while (i < entries.length) {
                            PiggyBackClassPathUtil.addEntryToVJETEntry(entries[i], vEntries, duplicateChecker);
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        VjetPlugin.error("Failed to resolve Java classpath container: " + sPath, e, 2);
                    }
                    break;
                }
            }
            ++n2;
        }
        return vEntries;
    }

    private static void savaVJetEntries(List<IBuildpathEntry> entries, IScriptProject project) {
        try {
            IBuildpathEntry[] oEntries = project.getRawBuildpath();
            int i = 0;
            while (i < oEntries.length) {
                if (oEntries[i].getEntryKind() != 1 && oEntries[i].getEntryKind() != 2) {
                    entries.add(0, oEntries[i]);
                }
                ++i;
            }
            project.setRawBuildpath(entries.toArray(new IBuildpathEntry[0]), null);
            PiggyBackClassPathUtil.setProjectInitialized(project.getProject());
        }
        catch (ModelException e) {
            e.printStackTrace();
            VjetPlugin.getDefault();
            VjetPlugin.error("Failed to update project build path.", e);
        }
    }

    public static void setProjectInitialized(IProject project) {
        IEclipsePreferences prefs = PiggyBackClassPathUtil.getProjectPreference(project, "org.eclipse.vjet.eclipse.core");
        if (prefs == null) {
            return;
        }
        prefs.putBoolean(PREFERENCE_SCRIPTPROJECT_INITIALIZED, true);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            VjetPlugin.error("Failed to save preference for " + project.getName(), e, 2);
        }
    }

    private static void addProjectEntry(IPath path, List<IBuildpathEntry> vEntries, List<String> duplicateChecker) {
        String str = path.toString();
        if (duplicateChecker.contains(str)) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(str);
        IScriptProject vProject = PiggyBackClassPathUtil.getScriptProject(project);
        if (project.exists() && vProject.exists()) {
            duplicateChecker.add(str);
            IBuildpathEntry pEntry = DLTKCore.newProjectEntry((IPath)path, (boolean)true);
            vEntries.add(pEntry);
        }
    }

    private static IScriptProject getScriptProject(IProject project) {
        IScriptProject vProject = DLTKCore.create((IProject)project);
        return vProject;
    }

    public static boolean isInSourceFolder(IResource resource) {
        List list = PiggyBackClassPathUtil.getProjectSrcPath_DLTK(PiggyBackClassPathUtil.getScriptProject(resource.getProject())).getSourcePaths();
        boolean isInSourceFolder = false;
        if (list != null) {
            for (String path : list) {
                if (path == null || path.equalsIgnoreCase("") || !resource.getProjectRelativePath().toOSString().startsWith(path.substring(1))) continue;
                isInSourceFolder = true;
                break;
            }
        }
        return isInSourceFolder;
    }

    public static ISdkEnvironment getSdkEnvironment() {
        return new VJetSdkEnvironment(new String[0], "DefaultSdk");
    }
}

