/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.RenameResourceElementsOperation;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.internal.core.util.Util;

public class VjetRenameResourceElementsOperation
extends RenameResourceElementsOperation {
    public VjetRenameResourceElementsOperation(IModelElement[] elements, IModelElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, newNames, force);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processSourceModuleResource(ISourceModule source, ScriptFolder dest) throws ModelException {
        String newCUName = this.getNewNameFor((IModelElement)source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        TextEdit textEdit = this.updateContent(source, dest, newCUName);
        IFile sourceResource = (IFile)source.getResource();
        String sourceEncoding = null;
        try {
            if (sourceResource != null) {
                sourceEncoding = sourceResource.getCharset(false);
            }
        }
        catch (CoreException coreException) {}
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile((IPath)new Path(destName));
        ISourceModule destCU = dest.createSourceModule(destName, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        if (sourceResource == null || !destFile.equals((Object)sourceResource)) {
            try {
                if (!destCU.isWorkingCopy()) {
                    int flags;
                    if (destFile.exists()) {
                        if (!this.force) throw new ModelException((IModelStatus)new ModelStatus(977, Messages.bind((String)Messages.status_nameCollision, (Object)destFile.getFullPath().toString())));
                        this.deleteResource((IResource)destFile, 2);
                        destCU.close();
                    }
                    int n = flags = this.force ? 1 : 0;
                    if (this.isMove()) {
                        flags |= 2;
                        if (sourceResource == null) {
                            if (!DLTKCore.DEBUG) throw new ModelException((IModelStatus)new ModelStatus(977, Messages.bind((String)Messages.status_invalidResource, (Object)destFile.getFullPath().toString())));
                            System.err.println("TODO: Add correct status message here...");
                            throw new ModelException((IModelStatus)new ModelStatus(977, Messages.bind((String)Messages.status_invalidResource, (Object)destFile.getFullPath().toString())));
                        }
                        sourceResource.move(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                    } else if (sourceResource == null) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
                        destFile.create((InputStream)bais, 1, this.getSubProgressMonitor(1));
                        destCU.getBuffer().setContents(source.getSourceAsCharArray());
                        destCU.save(this.getSubProgressMonitor(1), true);
                    } else {
                        sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                    }
                    this.setAttribute("hasModifiedResource", "true");
                } else {
                    destCU.getBuffer().setContents(source.getBuffer().getContents());
                }
            }
            catch (ModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
            if (textEdit != null) {
                boolean wasReadOnly = destFile.isReadOnly();
                try {
                    try {
                        this.saveContent(dest, destName, sourceEncoding, destFile, textEdit);
                    }
                    catch (CoreException e) {
                        if (!(e instanceof ModelException)) throw new ModelException(e);
                        throw (ModelException)((Object)e);
                    }
                }
                finally {
                    Util.setReadOnly((IResource)destFile, wasReadOnly);
                }
            }
            this.prepareDeltas((IModelElement)source, (IModelElement)destCU, this.isMove());
            if (newCUName == null) return;
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add remove extensions here...");
            }
            String oldName = source.getElementName();
            String newName = newCUName;
            this.prepareDeltas((IModelElement)source.getType(oldName), (IModelElement)destCU.getType(newName), this.isMove());
            return;
        }
        if (!this.force) {
            throw new ModelException((IModelStatus)new ModelStatus(977, Messages.bind((String)Messages.status_nameCollision, (Object)destFile.getFullPath().toString())));
        }
        try {
            if (textEdit == null) return;
            this.saveContent(dest, destName, sourceEncoding, destFile, textEdit);
            return;
        }
        catch (CoreException e) {
            if (!(e instanceof ModelException)) throw new ModelException(e);
            throw (ModelException)((Object)e);
        }
    }

    private void saveContent(ScriptFolder dest, String destName, String sourceEncoding, IFile destFile, TextEdit textEdits) throws ModelException {
        try {
            if (sourceEncoding != null) {
                destFile.setCharset(sourceEncoding, this.progressMonitor);
            }
        }
        catch (CoreException coreException) {}
        Util.setReadOnly((IResource)destFile, false);
        ISourceModule destCU = dest.getSourceModule(destName);
        IDocument document = this.getDocument(destCU);
        try {
            textEdits.apply(document);
        }
        catch (BadLocationException e) {
            throw new ModelException((Throwable)e, 984);
        }
        destCU.save(this.getSubProgressMonitor(1), this.force);
    }

    protected IDocument getDocument(ISourceModule cu) throws ModelException {
        IBuffer buffer = cu.getBuffer();
        if (buffer instanceof IDocument) {
            return (IDocument)buffer;
        }
        return new DocumentAdapter(buffer);
    }

    private TextEdit updateContent(ISourceModule cu, ScriptFolder dest, String newName) throws ModelException {
        String packagePattern = "\\.";
        Object[] currPackageName = ((IScriptFolder)cu.getParent()).getElementName().split(packagePattern);
        Object[] destPackageName = dest.getElementName().split(packagePattern);
        if (cu instanceof VjoSourceModule) {
            VjoSourceModule vjoSourceModule = (VjoSourceModule)cu;
            if (this.equalArraysOrNull(currPackageName, destPackageName) && newName == null) {
                return null;
            }
            cu.makeConsistent(this.progressMonitor);
            return this.updateTypeName(cu, vjoSourceModule.getJstType(), cu.getElementName(), newName);
        }
        return null;
    }

    private boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = len - 1;
        while (i >= 0) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    private String getNameWithoutJavaScriptLikeExtension(String name) {
        if (name.lastIndexOf(".") != -1) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    private TextEdit updateTypeName(ISourceModule cu, IJstType astCU, String oldName, String newName) throws ModelException {
        if (newName != null) {
            String oldTypeName = this.getNameWithoutJavaScriptLikeExtension(oldName);
            String newTypeName = this.getNameWithoutJavaScriptLikeExtension(newName);
            IType[] types = cu.getTypes();
            int i = 0;
            int max = types.length;
            while (i < max) {
                IType currentType = types[i];
                if (currentType.getElementName().equals(oldTypeName) && astCU != null) {
                    int start = astCU.getSource().getStartOffSet();
                    int length = astCU.getSource().getLength();
                    String matchText = cu.getBuffer().getText(start, length);
                    if (oldTypeName.equals(matchText)) {
                        ReplaceEdit replaceEdit = new ReplaceEdit(start, length, newTypeName);
                        return replaceEdit;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public class DocumentAdapter
    extends Document {
        private IBuffer buffer;

        public DocumentAdapter(IBuffer buffer) {
            super(buffer.getContents());
            this.buffer = buffer;
        }

        public void set(String text) {
            super.set(text);
            this.buffer.setContents(text);
        }

        public void replace(int offset, int length, String text) throws BadLocationException {
            super.replace(offset, length, text);
            this.buffer.replace(offset, length, text);
        }
    }
}

