/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;

public class JsDocHelper {
    public static void addJsDoc(IJsCommentMeta meta, JstMethod jstMethod) {
        JstDoc jsDocNode;
        String jsdoc;
        if (meta != null && meta.getCommentSrc() != null && (jsdoc = JsDocHelper.getJsDocFromStructuredComment(meta)) != "" && (jsDocNode = JsDocHelper.createJsDocNode(jsdoc)) != null) {
            jstMethod.setDoc((IJstDoc)jsDocNode);
        }
    }

    public static void addJsDoc(IJsCommentMeta meta, JstProperty property) {
        if (meta != null && meta.getCommentSrc() != null) {
            String jsdoc = JsDocHelper.getJsDocFromStructuredComment(meta);
            property.setDoc((IJstDoc)JsDocHelper.createJsDocNode(jsdoc));
        }
    }

    public static void addJsDoc(String jsdoc, JstProperty property) {
        if (jsdoc != null) {
            if (!jsdoc.trim().startsWith("/**")) {
                return;
            }
            property.setDoc((IJstDoc)JsDocHelper.createJsDocNode(jsdoc));
        }
    }

    private static String getJsDocFromStructuredComment(IJsCommentMeta meta) {
        String[] split = meta.getCommentSrc().split(";");
        StringBuilder jsdoc = new StringBuilder();
        if (split.length >= 2) {
            int i = 1;
            while (i < split.length) {
                jsdoc.append(split[i]);
                ++i;
            }
        } else {
            return null;
        }
        return jsdoc.toString().trim();
    }

    public static void addJsDoc(String jsdoc, JstType property) {
        if (jsdoc != null) {
            if (!jsdoc.trim().startsWith("/**")) {
                return;
            }
            property.setDoc((IJstDoc)JsDocHelper.createJsDocNode(jsdoc));
        }
    }

    public static void addJsDoc(IJsCommentMeta meta, JstType type) {
        String jsdoc;
        if (meta != null && meta.getCommentSrc() != null && (jsdoc = JsDocHelper.getJsDocFromStructuredComment(meta)) != "") {
            type.setDoc((IJstDoc)JsDocHelper.createJsDocNode(jsdoc));
        }
    }

    private static JstDoc createJsDocNode(String jsdoc) {
        jsdoc = JsDocHelper.cleanJsDocComment(jsdoc);
        return new JstDoc(jsdoc);
    }

    public static String getJsDocFromVjetComment(String vjetDoc) {
        String[] vjetDoc2;
        if (vjetDoc == null) {
            return null;
        }
        if (vjetDoc.indexOf(";") != -1 && (vjetDoc2 = vjetDoc.split(";")).length > 1) {
            return JsDocHelper.cleanJsDocComment(vjetDoc2[1]);
        }
        return "";
    }

    public static String cleanJsDocComment(String jsdoc) {
        if (jsdoc == null) {
            return null;
        }
        jsdoc = jsdoc.trim();
        jsdoc = jsdoc.replaceAll("^/\\*\\*", "");
        jsdoc = jsdoc.replaceAll("^\\*", "");
        jsdoc = jsdoc.replaceAll("\\*/$", "");
        jsdoc = jsdoc.replaceAll("\\s+\\*", "\n");
        return jsdoc;
    }

    public static void addJsDoc(String jsdoc, JstMethod method) {
        if (jsdoc != null) {
            if (!jsdoc.trim().startsWith("/**")) {
                return;
            }
            method.setDoc((IJstDoc)JsDocHelper.createJsDocNode(jsdoc));
        }
    }
}

