/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.dbgp.IDbgpStatus;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpOpertionCanceledException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpTimeoutException;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;

public abstract class DbgpOperation {
    private static final boolean DEBUG = DLTKCore.DEBUG;
    private final Job job;
    private final IDbgpCommands commands;
    private final IResultHandler resultHandler;

    protected IDbgpCoreCommands getCore() {
        return this.commands.getCoreCommands();
    }

    protected IDbgpExtendedCommands getExtended() {
        return this.commands.getExtendedCommands();
    }

    protected void callFinish(IDbgpStatus status) {
        if (DEBUG) {
            System.out.println("Status: " + status);
        }
        this.resultHandler.finish(status, null);
    }

    protected DbgpOperation(IScriptThread thread, String name, IResultHandler handler) {
        this.resultHandler = handler;
        this.commands = thread.getDbgpSession();
        this.job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DbgpOperation.this.process();
                }
                catch (DbgpOpertionCanceledException dbgpOpertionCanceledException) {
                }
                catch (DbgpTimeoutException e) {
                    System.err.println("Timeout exception!!!");
                    e.printStackTrace();
                }
                catch (DbgpException e) {
                    if (DLTKCore.DEBUG) {
                        System.out.println("Exception: " + e.getMessage());
                        System.out.println(e.getClass());
                        e.printStackTrace();
                    }
                    DbgpOperation.this.resultHandler.finish(null, e);
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(true);
        this.job.setUser(false);
    }

    public void schedule() {
        if (DEBUG) {
            System.out.println("Starting operation: " + this.job.getName());
        }
        this.job.schedule();
    }

    protected abstract void process() throws DbgpException;

    public static interface IResultHandler {
        public void finish(IDbgpStatus var1, DbgpException var2);
    }
}

