/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.interpreters;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.mod.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterInstallType;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class InterpretersUpdater {
    private InterpreterDefinitionsContainer fOriginalInterpreters;

    public InterpretersUpdater() {
        this.saveCurrentAsOriginal();
    }

    private void saveCurrentAsOriginal() {
        this.fOriginalInterpreters = new InterpreterDefinitionsContainer();
        ScriptRuntime.DefaultInterpreterEntry[] entries = ScriptRuntime.getDefaultInterpreterIDs();
        int i = 0;
        while (i < entries.length) {
            ScriptRuntime.DefaultInterpreterEntry entry = entries[i];
            IInterpreterInstall def = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)entry);
            if (def != null) {
                this.fOriginalInterpreters.setDefaultInterpreterInstallCompositeID(entry, ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)def));
            }
            ++i;
        }
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes();
        int i2 = 0;
        while (i2 < types.length) {
            IInterpreterInstall[] installs = types[i2].getInterpreterInstalls();
            if (installs != null) {
                int j = 0;
                while (j < installs.length) {
                    this.fOriginalInterpreters.addInterpreter(installs[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    public boolean updateInterpreterSettings(String langNatureId, IInterpreterInstall[] interpreters, IInterpreterInstall[] defaultInterpreters) {
        ScriptRuntime.DefaultInterpreterEntry entry;
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        HashSet<IEnvironment> envs = new HashSet<IEnvironment>();
        if (defaultInterpreters != null) {
            int i = 0;
            while (i < defaultInterpreters.length) {
                String defaultId = ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)defaultInterpreters[i]);
                IEnvironment environment = defaultInterpreters[i].getEnvironment();
                entry = new ScriptRuntime.DefaultInterpreterEntry(langNatureId, environment.getId());
                container.setDefaultInterpreterInstallCompositeID(entry, defaultId);
                envs.add(environment);
                ++i;
            }
        }
        IEnvironment[] environments = EnvironmentManager.getEnvironments();
        int i = 0;
        while (i < environments.length) {
            if (!envs.contains(environments[i])) {
                ScriptRuntime.DefaultInterpreterEntry entry2 = new ScriptRuntime.DefaultInterpreterEntry(langNatureId, environments[i].getId());
                container.setDefaultInterpreterInstallCompositeID(entry2, null);
            }
            ++i;
        }
        i = 0;
        while (i < interpreters.length) {
            container.addInterpreter(interpreters[i]);
            ++i;
        }
        ScriptRuntime.DefaultInterpreterEntry[] entries = this.fOriginalInterpreters.getInterpreterNatures();
        int i2 = 0;
        while (i2 < entries.length) {
            entry = entries[i2];
            if (!langNatureId.equals(entry.getNature())) {
                String defaultId = this.fOriginalInterpreters.getDefaultInterpreterInstallCompositeID(entry);
                container.setDefaultInterpreterInstallCompositeID(entry, defaultId);
            }
            ++i2;
        }
        for (IInterpreterInstall install : this.fOriginalInterpreters.getInterpreterList()) {
            if (langNatureId.equals(install.getInterpreterInstallType().getNatureId())) continue;
            container.addInterpreter(install);
        }
        this.saveInterpreterDefinitions(container);
        this.saveCurrentAsOriginal();
        return true;
    }

    private void saveInterpreterDefinitions(final InterpreterDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(InterpretersMessages.InterpretersUpdater_0, 100);
                        String xml = container.getAsXML();
                        monitor.worked(40);
                        ScriptRuntime.getPreferences().setValue(ScriptRuntime.PREF_INTERPRETER_XML, xml);
                        monitor.worked(30);
                        ScriptRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        DLTKDebugUIPlugin.log(ioe);
                        monitor.done();
                    }
                    catch (ParserConfigurationException e) {
                        DLTKDebugUIPlugin.log(e);
                        monitor.done();
                    }
                    catch (TransformerException e) {
                        DLTKDebugUIPlugin.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            DLTKDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            DLTKDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            DLTKDebugUIPlugin.log(e);
        }
    }
}

