/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.search.SearchDocument;
import org.eclipse.dltk.mod.core.search.SearchParticipant;

public class DLTKSearchDocument
extends SearchDocument {
    protected char[] charContents;
    private boolean external;

    public DLTKSearchDocument(String path, char[] contents, SearchParticipant participant, boolean external, IProject project) {
        super(path, participant, project);
        this.charContents = contents;
        this.external = external;
    }

    public DLTKSearchDocument(String path, IPath containerPath, char[] contents, SearchParticipant participant, boolean external, IProject project) {
        super("|" + path, participant, project);
        this.charContents = contents;
        this.external = external;
    }

    @Override
    public String getContents() {
        return new String(this.charContents);
    }

    @Override
    public char[] getCharContents() {
        return this.charContents;
    }

    @Override
    public String getEncoding() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String toString() {
        return "SearchDocument for " + this.getPath();
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }
}

