/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.search.index.Index;
import org.eclipse.dltk.mod.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.mod.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.mod.internal.core.ExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.mixin.MixinIndexRequest;

public class MixinExternalProjectFragmentRequest
extends MixinIndexRequest {
    protected final IProjectFragment fragment;
    protected final IDLTKLanguageToolkit toolkit;

    public MixinExternalProjectFragmentRequest(IProjectFragment fragment, IDLTKLanguageToolkit toolkit) {
        this.fragment = fragment;
        this.toolkit = toolkit;
    }

    @Override
    protected String getName() {
        return this.fragment.getElementName();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws CoreException, IOException {
        IPath containerPath;
        Set modules = this.getExternalSourceModules();
        Index index = this.getProjectFragmentIndex(this.fragment);
        List changes = this.checkChanges(index, modules, containerPath = this.fragment.getPath(), this.getEnvironment());
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            block19: {
                Iterator i;
                block18: {
                    i = changes.iterator();
                    if (!true) break block18;
                    if (this.isCancelled) return;
                    if (!i.hasNext()) break block19;
                }
                do {
                    Object change;
                    if ((change = i.next()) instanceof String) {
                        index.remove((String)change);
                    } else {
                        this.indexSourceModule(index, this.toolkit, (ISourceModule)change, containerPath);
                    }
                    if (this.isCancelled) return;
                } while (i.hasNext());
            }
            return;
        }
        finally {
            block17: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    protected IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment(this.fragment);
    }

    private Set getExternalSourceModules() throws ModelException {
        ExternalModuleVisitor visitor = new ExternalModuleVisitor();
        this.fragment.accept(visitor);
        return visitor.modules;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MixinExternalProjectFragmentRequest other = (MixinExternalProjectFragmentRequest)obj;
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set modules = new HashSet();

        ExternalModuleVisitor() {
        }

        @Override
        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                if (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule) {
                    this.modules.add(element);
                }
                return false;
            }
            return true;
        }
    }
}

