/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.IJSMemberElementInfo;
import org.eclipse.dltk.mod.internal.core.JSTypeParameter;
import org.eclipse.dltk.mod.internal.core.JSTypeParameterElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceMethodElementInfo;
import org.eclipse.vjet.eclipse.core.IJSTypeParameter;

public class JSSourceMethodElementInfo
extends SourceMethodElementInfo
implements IJSMemberElementInfo {
    private static final char[] CONSTRUCTOR_RETURN_TYPE_NAME = new char[]{'v', 'o', 'i', 'd'};
    private boolean m_isConstructor;
    protected char[] returnType;
    protected IJSTypeParameter[] typeParameters = JSTypeParameter.NO_TYPE_PARAMETERS;

    @Override
    public char[] getReturnTypeName() {
        if (this.m_isConstructor) {
            return CONSTRUCTOR_RETURN_TYPE_NAME;
        }
        return this.returnType;
    }

    @Override
    public char[][][] getTypeParameterBounds() {
        int length = this.typeParameters.length;
        char[][][] typeParameterBounds = new char[length][][];
        int i = 0;
        while (i < length) {
            try {
                JSTypeParameterElementInfo info = (JSTypeParameterElementInfo)((ModelElement)((Object)this.typeParameters[i])).getElementInfo();
                typeParameterBounds[i] = info.m_bounds;
            }
            catch (ModelException modelException) {}
            ++i;
        }
        return typeParameterBounds;
    }

    @Override
    public char[][] getTypeParameterNames() {
        int length = this.typeParameters.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] typeParameterNames = new char[length][];
        int i = 0;
        while (i < length) {
            typeParameterNames[i] = this.typeParameters[i].getElementName().toCharArray();
            ++i;
        }
        return typeParameterNames;
    }

    @Override
    public boolean isConstructor() {
        return this.m_isConstructor;
    }

    @Override
    public void setArgumentInializers(String[] initializers) {
        super.setArgumentInializers(initializers);
    }

    @Override
    public void setArgumentNames(String[] names) {
        super.setArgumentNames(names);
    }

    public void setConstructor(boolean isConstructor) {
        this.m_isConstructor = isConstructor;
    }

    @Override
    public void setFlags(int flags) {
        super.setFlags(flags);
    }

    @Override
    public void setNameSourceEnd(int end) {
        super.setNameSourceEnd(end);
    }

    @Override
    public void setNameSourceStart(int start) {
        super.setNameSourceStart(start);
    }

    public void setReturnType(char[] type) {
        this.returnType = type;
    }

    @Override
    public void setSourceRangeEnd(int end) {
        super.setSourceRangeEnd(end);
    }

    @Override
    public void setSourceRangeStart(int start) {
        super.setSourceRangeStart(start);
    }
}

