/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.core.ExternalProjectFragmentInfo;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolderInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class ExternalProjectFragment
extends ProjectFragment {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath fPath;
    protected final boolean fReadOnly;
    protected final boolean fOnlyScriptResources;

    protected ExternalProjectFragment(IPath path, ScriptProject project, boolean isReadOnly, boolean onlyScriptResources) {
        super(null, project);
        this.fPath = path;
        this.fReadOnly = isReadOnly;
        this.fOnlyScriptResources = onlyScriptResources;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        ArrayList vChildren = new ArrayList(5);
        ArrayList vForeign = new ArrayList(5);
        char[][] inclusionPatterns = this.fullInclusionPatternChars();
        char[][] exclusionPatterns = this.fullExclusionPatternChars();
        HashSet realPaths = new HashSet();
        this.computeFolderChildren(this.fPath, !Util.isExcluded(this.fPath, inclusionPatterns, exclusionPatterns, true), vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns, realPaths);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeFolderChildren(IPath path, boolean isIncluded, ArrayList vChildren, ArrayList vForeign, Map newElements, char[][] inclusionPatterns, char[][] exclusionPatterns, Set realPaths) throws ModelException {
        IFileHandle file;
        String canonicalPath;
        IPath lpath = EnvironmentPathUtils.getLocalPath(path.removeFirstSegments(this.fPath.segmentCount()));
        IEnvironment environment = EnvironmentPathUtils.getPathEnvironment(path);
        if (environment != null && !realPaths.add(canonicalPath = (file = environment.getFile(EnvironmentPathUtils.getLocalPath(path))).getCanonicalPath())) {
            return;
        }
        ExternalScriptFolder fldr = (ExternalScriptFolder)this.getScriptFolder(lpath);
        boolean valid = Util.isValidSourcePackageName(this, path);
        if ((lpath.segmentCount() == 0 || valid) && isIncluded) {
            vChildren.add(fldr);
        } else {
            if (this.fOnlyScriptResources) {
                return;
            }
            if (!valid) {
                return;
            }
        }
        ArrayList<IPath> scriptElements = new ArrayList<IPath>();
        ArrayList<IPath> nonScriptElements = new ArrayList<IPath>();
        try {
            IFileHandle file2 = EnvironmentPathUtils.getFile(path);
            IFileHandle[] members = file2.getChildren();
            if (members != null) {
                int i = 0;
                int max = members.length;
                while (i < max) {
                    IFileHandle memberFile = members[i];
                    IPath memberPath = memberFile.getFullPath();
                    if (memberFile.isDirectory()) {
                        boolean isMemberIncluded = !Util.isExcluded(memberPath, inclusionPatterns, exclusionPatterns, true);
                        this.computeFolderChildren(memberPath, isMemberIncluded, vChildren, vForeign, newElements, inclusionPatterns, exclusionPatterns, realPaths);
                    } else if (Util.isValidSourceModule((IModelElement)this, memberPath)) {
                        scriptElements.add(memberPath);
                    } else if (!this.fOnlyScriptResources || valid) {
                        nonScriptElements.add(memberPath);
                    }
                    ++i;
                }
            }
            ExternalScriptFolderInfo fragInfo = new ExternalScriptFolderInfo();
            fldr.computeChildren(fragInfo, scriptElements);
            fldr.computeForeignResources(fragInfo, nonScriptElements);
            newElements.put(fldr, fragInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        block4: {
            try {
                ArrayList childs = this.getChildrenOfType(4);
                int i = 0;
                while (i < childs.size()) {
                    IScriptFolder folder = (IScriptFolder)childs.get(i);
                    if (folder.getElementName().equals(path.toPortableString())) {
                        return folder;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new ExternalScriptFolder(this, path);
    }

    @Override
    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    @Override
    protected Object createElementInfo() {
        return new ExternalProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        return null;
    }

    @Override
    public int hashCode() {
        return this.fPath.hashCode();
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected boolean resourceExists() {
        if (this.fPath.toString().startsWith("#special#builtin#")) {
            return true;
        }
        IFileHandle file = EnvironmentPathUtils.getFile(this.fPath);
        return file.exists() && file.isDirectory();
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExternalProjectFragment) {
            IEnvironment environmento;
            ExternalProjectFragment other = (ExternalProjectFragment)o;
            IEnvironment environment = EnvironmentManager.getEnvironment(this);
            if (environment != null && !environment.equals(environmento = EnvironmentManager.getEnvironment(other))) {
                return false;
            }
            return this.fPath.equals((Object)other.fPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        IEnvironment env = EnvironmentManager.getEnvironment(this);
        String pathString = EnvironmentPathUtils.getLocalPathString(this.fPath);
        return pathString.replace(env.getSeparatorChar(), '>');
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IBuildpathEntry getBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = super.getRawBuildpathEntry();
        if (rawEntry != null && rawEntry.getEntryKind() == 5) {
            IBuildpathContainer container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), this.getScriptProject());
            IBuildpathEntry[] entrys = container.getBuildpathEntries(this.getScriptProject());
            int i = 0;
            while (i < entrys.length) {
                if (entrys[i].getPath().equals((Object)this.getPath())) {
                    return entrys[i];
                }
                ++i;
            }
        }
        return rawEntry;
    }
}

