/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;

public abstract class AbstractLanguageToolkit
implements IDLTKLanguageToolkit {
    @Override
    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    @Override
    public boolean validateSourcePackage(IPath path, IEnvironment environment) {
        return true;
    }

    @Override
    public IStatus validateSourceModule(IResource resource) {
        return Status.OK_STATUS;
    }

    protected static boolean isEmptyExtension(String name) {
        return name.indexOf(46) == -1;
    }

    @Override
    public boolean canValidateContent(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IEnvironment environment = EnvironmentManager.getEnvironment(project);
        if (environment == null || !environment.isLocal()) {
            return false;
        }
        return AbstractLanguageToolkit.isEmptyExtension(resource.getName());
    }

    @Override
    public boolean canValidateContent(File file) {
        return AbstractLanguageToolkit.isEmptyExtension(file.getName());
    }

    @Override
    public boolean canValidateContent(IFileHandle file) {
        return false;
    }

    @Override
    public String getPreferenceQualifier() {
        return null;
    }
}

