/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.http.impl.AssembledHttpRequest;

class AssembledFullHttpRequest
extends AssembledHttpRequest
implements FullHttpRequest {
    public AssembledFullHttpRequest(HttpRequest request, LastHttpContent content) {
        super(request, (HttpContent)content);
    }

    public AssembledFullHttpRequest(HttpRequest request) {
        super(request, (HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public AssembledFullHttpRequest(HttpRequest request, ByteBuf buf) {
        super(request, (HttpContent)AssembledFullHttpRequest.toLastContent(buf));
    }

    private static LastHttpContent toLastContent(ByteBuf buf) {
        if (buf.isReadable()) {
            return new DefaultLastHttpContent(buf, false);
        }
        return LastHttpContent.EMPTY_LAST_CONTENT;
    }

    @Override
    public AssembledFullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public AssembledFullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public AssembledFullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public AssembledFullHttpRequest duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssembledFullHttpRequest copy() {
        throw new UnsupportedOperationException();
    }

    public HttpHeaders trailingHeaders() {
        return ((LastHttpContent)this.content).trailingHeaders();
    }

    @Override
    public AssembledFullHttpRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public AssembledFullHttpRequest retain(int increment) {
        super.retain(increment);
        return this;
    }
}

