/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.vertx.core.dns.impl.netty.DnsMessage;
import java.util.Objects;

public class DnsHeader {
    public static final int TYPE_QUERY = 0;
    public static final int TYPE_RESPONSE = 1;
    public static final int OPCODE_QUERY = 0;
    @Deprecated
    public static final int OPCODE_IQUERY = 1;
    private final DnsMessage<? extends DnsHeader> parent;
    private boolean recursionDesired;
    private int opcode;
    private int id;
    private int type;

    public DnsHeader(DnsMessage<? extends DnsHeader> parent) {
        Objects.requireNonNull(parent, "the parent field cannot be null and must point to a valid DnsMessage.");
        this.parent = parent;
    }

    public int questionCount() {
        return this.parent.getQuestions().size();
    }

    public int answerCount() {
        return this.parent.getAnswers().size();
    }

    public int authorityResourceCount() {
        return this.parent.getAuthorityResources().size();
    }

    public int additionalResourceCount() {
        return this.parent.getAdditionalResources().size();
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public DnsHeader setOpcode(int opcode) {
        this.opcode = opcode;
        return this;
    }

    public DnsHeader setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public DnsHeader setType(int type) {
        this.type = type;
        return this;
    }

    public DnsHeader setId(int id) {
        this.id = id;
        return this;
    }
}

