/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval.guideline;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IGuidelineItem;
import org.eclipse.actf.visualization.eval.ITechniquesItem;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidelineData
implements IGuidelineData {
    private String guidelineName;
    private int id;
    private String levelStr = null;
    private String[] levels;
    private String[] mimetypes;
    private String description;
    private String category;
    private boolean isEnabled = false;
    private GuidelineData[] subLevelDataArray = new GuidelineData[0];
    private boolean[] hasMetrics;
    private HashSet<IEvaluationItem> checkItemSet = new HashSet();
    private Map<String, IGuidelineItem> guidelineItemMap = new HashMap<String, IGuidelineItem>();
    private Map<String, ITechniquesItem> techniquesItemMap = new HashMap<String, ITechniquesItem>();
    private String currentMIMEtype = "text/html";

    public GuidelineData(String string, int n, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Map<String, IGuidelineItem> map) {
        this.guidelineName = string;
        this.guidelineItemMap = map;
        this.levels = stringArray;
        this.mimetypes = stringArray4;
        this.id = n;
        this.category = string2;
        this.description = string3;
        this.subLevelDataArray = new GuidelineData[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.subLevelDataArray[n2] = new GuidelineData(string, n, stringArray[n2], stringArray2[n2], stringArray3[n2], stringArray4, map);
            ++n2;
        }
    }

    public GuidelineData(String string, int n, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Map<String, IGuidelineItem> map, Map<String, ITechniquesItem> map2) {
        this.guidelineName = string;
        this.guidelineItemMap = map;
        this.techniquesItemMap = map2;
        this.levels = stringArray;
        this.mimetypes = stringArray4;
        this.id = n;
        this.category = string2;
        this.description = string3;
        this.subLevelDataArray = new GuidelineData[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.subLevelDataArray[n2] = new GuidelineData(string, n, stringArray[n2], stringArray2[n2], stringArray3[n2], stringArray4, map);
            ++n2;
        }
    }

    private GuidelineData(String string, int n, String string2, String string3, String string4, String[] stringArray, Map<String, IGuidelineItem> map) {
        this.guidelineName = string;
        this.id = n;
        this.mimetypes = stringArray;
        this.category = string3;
        this.description = string4;
        this.levelStr = string2 == null ? "" : string2;
        for (IGuidelineItem iGuidelineItem : map.values()) {
            if (!iGuidelineItem.getLevel().equals(string2)) continue;
            this.guidelineItemMap.put(iGuidelineItem.getId(), iGuidelineItem);
        }
    }

    @Override
    public IGuidelineItem getGuidelineItem(String string) {
        return this.guidelineItemMap.get(string);
    }

    public Map<String, IGuidelineItem> getGuidelineItemMap() {
        return this.guidelineItemMap;
    }

    @Override
    public String getGuidelineName() {
        return this.guidelineName;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String[] getLevels() {
        return this.levels;
    }

    @Override
    public boolean hasLevel() {
        return this.levels.length != 0;
    }

    @Override
    public String[] getMIMEtypes() {
        return this.mimetypes;
    }

    @Override
    public boolean isEnabled() {
        if (this.subLevelDataArray.length > 0) {
            int n = 0;
            while (n < this.subLevelDataArray.length) {
                if (this.subLevelDataArray[n].isEnabled()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return this.isEnabled;
    }

    @Override
    public boolean isMatched() {
        return this.isEnabled() && this.isTargetMIMEtype(this.currentMIMEtype);
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        for (IGuidelineItem iGuidelineItem : this.guidelineItemMap.values()) {
            iGuidelineItem.setEnabled(bl);
        }
    }

    @Override
    public GuidelineData getSubLevelData(String string) {
        int n = 0;
        while (n < this.subLevelDataArray.length) {
            if (this.subLevelDataArray[n].getLevelStr().equalsIgnoreCase(string)) {
                return this.subLevelDataArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setEvaluationItems(Collection<IEvaluationItem> collection, String[] stringArray) {
        this.hasMetrics = new boolean[stringArray.length];
        Arrays.fill(this.hasMetrics, false);
        for (IEvaluationItem iEvaluationItem : collection) {
            IGuidelineItem[] iGuidelineItemArray = iEvaluationItem.getGuidelines();
            int n = 0;
            while (n < iGuidelineItemArray.length) {
                if (this.guidelineName.equals(iGuidelineItemArray[n].getGuidelineName()) && (this.levelStr == null || this.levelStr.equals(iGuidelineItemArray[n].getLevel()))) {
                    Image[] imageArray = iEvaluationItem.getMetricsIcons();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (imageArray[n2] != null) {
                            this.hasMetrics[n2] = true;
                        }
                        ++n2;
                    }
                    this.checkItemSet.add(iEvaluationItem);
                }
                ++n;
            }
        }
        int n = 0;
        while (n < this.subLevelDataArray.length) {
            this.subLevelDataArray[n].setEvaluationItems(collection, stringArray);
            ++n;
        }
    }

    @Override
    public String getLevelStr() {
        return this.levelStr;
    }

    public HashSet<IEvaluationItem> getEvaluationItemSet() {
        return this.checkItemSet;
    }

    public boolean[] getCorrespondingMetrics() {
        return this.hasMetrics;
    }

    @Override
    public boolean isTargetMIMEtype(String string) {
        int n = 0;
        while (n < this.mimetypes.length) {
            if (this.mimetypes[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setCurrentMIMEtype(String string) {
        this.currentMIMEtype = string;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ITechniquesItem getTequniquesItem(String string) {
        return this.techniquesItemMap.get(string);
    }
}

