/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal.menu;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.tea.core.TaskingEngine;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.config.TaskingDevelopmentConfig;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.internal.model.iface.TaskingContainer;
import org.eclipse.tea.core.internal.model.iface.TaskingElement;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.ui.TaskingEngineJob;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;
import org.eclipse.tea.core.ui.internal.TaskingImageHelper;

public class DynamicTaskingMenu {
    @Inject
    private TaskingModel model;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        IEclipseContext configuredContext = TaskingInjectionHelper.createConfiguredContext((TaskingConfigurationStore)new TaskingEclipsePreferenceStore());
        TaskingDevelopmentConfig cfg = (TaskingDevelopmentConfig)configuredContext.get(TaskingDevelopmentConfig.class);
        this.createMenu(cfg, items, this.model.getRootGroup());
    }

    private void createMenu(TaskingDevelopmentConfig cfg, List<MMenuElement> target, TaskingContainer group) {
        String lastGroupingId = null;
        for (TaskingElement e : group.getChildren()) {
            if (e.isDevelopment() && !cfg.showHiddenTaskChains) continue;
            if (lastGroupingId != null && !lastGroupingId.equals(e.getGroupingId())) {
                target.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
            }
            lastGroupingId = e.getGroupingId();
            if (e instanceof TaskingContainer) {
                MMenu sub = MMenuFactory.INSTANCE.createMenu();
                sub.setLabel(this.getLabel(cfg, e));
                sub.setIconURI(TaskingImageHelper.getIconUri(e.getIconBundle(), e.getIconPath()));
                target.add((MMenuElement)sub);
                this.createMenu(cfg, sub.getChildren(), (TaskingContainer)e);
                continue;
            }
            if (!(e instanceof TaskingItem) || !((TaskingItem)e).isVisibleInMenu()) continue;
            MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
            item.setLabel(this.getLabel(cfg, e));
            item.setIconURI(TaskingImageHelper.getIconUri(e.getIconBundle(), e.getIconPath()));
            item.setObject((Object)new DynamicTaskChainMenuHandler(((TaskingItem)e).getChain()));
            target.add((MMenuElement)item);
        }
    }

    private String getLabel(TaskingDevelopmentConfig config, TaskingElement element) {
        if (!config.showGroupingIds) {
            return element.getLabel();
        }
        return "[" + element.getGroupingId() + "] " + element.getLabel();
    }

    public static final class DynamicTaskChainMenuHandler {
        private final TaskChain chain;

        public DynamicTaskChainMenuHandler(TaskChain chain) {
            this.chain = chain;
        }

        @Execute
        public void handle() {
            TaskingEngine engine = TaskingEngine.withConfiguration((TaskingConfigurationStore)new TaskingEclipsePreferenceStore());
            TaskingEngineJob j = new TaskingEngineJob(engine, this.chain);
            j.schedule();
        }

        @CanExecute
        public boolean checkRunning() {
            return Job.getJobManager().find(TaskChain.class).length == 0;
        }
    }
}

