/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public class MetamodelResourceFactory
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        XMIResourceImpl resource = new XMIResourceImpl(uri){

            protected boolean useIDs() {
                return this.eObjectToIDMap != null || this.idToEObjectMap != null;
            }

            protected XMLHelper createXMLHelper() {
                return new XMLHelperImpl((XMLResource)this){

                    public String getHREF(EObject obj) {
                        return super.getHREF(obj);
                    }
                };
            }
        };
        resource.setEncoding("UTF-8");
        resource.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        resource.getDefaultSaveOptions().put("LINE_WIDTH", 80);
        resource.getDefaultSaveOptions().put("URI_HANDLER", new MetamodelURIHandler());
        resource.getDefaultLoadOptions().put("URI_HANDLER", new MetamodelURIHandler());
        return resource;
    }

    public static class MetamodelURIHandler
    extends URIHandlerImpl.PlatformSchemeAware {
        public URI deresolve(URI uri) {
            uri.isPlatform();
            URI after = super.deresolve(uri);
            return after;
        }

        public URI resolve(URI uri) {
            if (uri.isPlatform()) {
                if (uri.isPlatformPlugin()) {
                    uri = URI.createPlatformResourceURI((String)uri.toPlatformString(true), (boolean)true).appendFragment(uri.fragment());
                }
                if (uri.isPlatformResource()) {
                    Path workspacePath = new Path(uri.toPlatformString(true));
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath);
                    if (!file.exists()) {
                        uri = URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)true).appendFragment(uri.fragment());
                    }
                }
            }
            return super.resolve(uri);
        }
    }
}

