/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.Messages;
import org.eclipse.stem.core.STEMBinaryResourceFactoryImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.STEMXMIResourceFactoryImpl;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Utility {
    public static final Map<String, String> EMF_SAVE_OPTIONS = new HashMap<String, String>();
    private static final Map<String, Object> EMF_SAVE_OPTIONS_KEEP_DEFAULTS = new HashMap<String, Object>();
    public static ResourceSet resourceSet;
    private static ArrayList<String> INCLUDE_FOLDERS;

    static {
        EMF_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        EMF_SAVE_OPTIONS_KEEP_DEFAULTS.put("ENCODING", "UTF-8");
        EMF_SAVE_OPTIONS_KEEP_DEFAULTS.put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
        resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        INCLUDE_FOLDERS = new ArrayList();
        INCLUDE_FOLDERS.add("decorators");
        INCLUDE_FOLDERS.add("experiments");
        INCLUDE_FOLDERS.add("models");
        INCLUDE_FOLDERS.add("modifiers");
        INCLUDE_FOLDERS.add("predicates");
        INCLUDE_FOLDERS.add("scenarios");
        INCLUDE_FOLDERS.add("sequencers");
        INCLUDE_FOLDERS.add("triggers");
        INCLUDE_FOLDERS.add("loggers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Identifiable getIdentifiable(URI identifableURI) {
        EList cont;
        Identifiable retValue;
        block10: {
            retValue = null;
            URI normalized = STEMURI.normalize(identifableURI);
            Resource resource = null;
            ResourceSet resourceSet = Utility.resourceSet;
            synchronized (resourceSet) {
                resource = Utility.resourceSet.getResource(normalized, true);
                if (resource.isModified()) {
                    resource.unload();
                    resource.load(null);
                    if (resource.getErrors().size() > 0) {
                        for (Resource.Diagnostic d : resource.getErrors()) {
                            CorePlugin.logError(d.getMessage(), new Exception());
                        }
                    }
                }
            }
            cont = resource.getContents();
            if (cont.size() != 0) break block10;
            int maxretry = 10;
            while (cont.size() == 0 && --maxretry > 0) {
                Thread.yield();
            }
            if (cont.size() != 0) break block10;
            CorePlugin.logError(NLS.bind((String)Messages.Utility_UNABLE_TO_LOAD_CONTENT, (Object[])new Object[]{normalized}), new Exception());
            return null;
        }
        try {
            retValue = (Identifiable)cont.get(0);
        }
        catch (Exception e) {
            CorePlugin.logError(NLS.bind((String)Messages.Utility_BAD_SERIALIZED_INSTANCE, (Object[])new Object[]{identifableURI.toString()}), e);
            retValue = null;
        }
        return retValue;
    }

    public static Identifiable getIdentifiableForceLoad(URI identifableURI) {
        EList cont;
        Identifiable retValue;
        block7: {
            retValue = null;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
            resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
            URI normalized = STEMURI.normalize(identifableURI);
            Resource resource = null;
            resource = resourceSet.getResource(normalized, true);
            if (resource.isModified()) {
                resource.unload();
                resource.load(null);
                if (resource.getErrors().size() > 0) {
                    for (Resource.Diagnostic d : resource.getErrors()) {
                        CorePlugin.logError(d.getMessage(), new Exception());
                    }
                }
            }
            if ((cont = resource.getContents()).size() != 0) break block7;
            int maxretry = 10;
            while (cont.size() == 0 && --maxretry > 0) {
                Thread.yield();
            }
            if (cont.size() != 0) break block7;
            CorePlugin.logError(NLS.bind((String)Messages.Utility_UNABLE_TO_LOAD_CONTENT, (Object[])new Object[]{normalized}), new Exception());
            return null;
        }
        try {
            retValue = (Identifiable)cont.get(0);
        }
        catch (Exception e) {
            CorePlugin.logError(NLS.bind((String)Messages.Utility_BAD_SERIALIZED_INSTANCE, (Object[])new Object[]{identifableURI.toString()}), e);
            retValue = null;
        }
        return retValue;
    }

    public static Identifiable getIdentifiableFromStream(URI identifableURI, InputStream is, Map<String, Object> options, boolean binary) {
        EList cont;
        Identifiable retValue;
        block8: {
            retValue = null;
            URI normalized = STEMURI.normalize(identifableURI);
            Resource resource = null;
            ResourceSetImpl rs = new ResourceSetImpl();
            if (binary) {
                rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMBinaryResourceFactoryImpl.INSTANCE);
                rs.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMBinaryResourceFactoryImpl.INSTANCE);
            } else {
                rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
                rs.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
            }
            resource = rs.createResource(normalized, null);
            resource.unload();
            resource.load(is, options);
            if (resource.getErrors().size() > 0) {
                for (Resource.Diagnostic d : resource.getErrors()) {
                    CorePlugin.logError(d.getMessage(), new Exception());
                }
            }
            if ((cont = resource.getContents()).size() != 0) break block8;
            int maxretry = 10;
            while (cont.size() == 0 && --maxretry > 0) {
                Thread.yield();
            }
            if (cont.size() != 0) break block8;
            CorePlugin.logError(NLS.bind((String)Messages.Utility_UNABLE_TO_LOAD_CONTENT, (Object[])new Object[]{normalized}), new Exception());
            return null;
        }
        try {
            retValue = (Identifiable)cont.get(0);
        }
        catch (Exception e) {
            CorePlugin.logError(NLS.bind((String)Messages.Utility_BAD_SERIALIZED_INSTANCE, (Object[])new Object[]{identifableURI.toString()}), e);
            retValue = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(URI identifableURI) {
        try {
            URI normalized = STEMURI.normalize(identifableURI);
            Resource resource = null;
            ResourceSet resourceSet = Utility.resourceSet;
            synchronized (resourceSet) {
                resource = Utility.resourceSet.getResource(normalized, true);
                if (resource.isModified()) {
                    resource.unload();
                    resource.load(null);
                    if (resource.getErrors().size() > 0) {
                        for (Resource.Diagnostic d : resource.getErrors()) {
                            CorePlugin.logError(d.getMessage(), new Exception());
                        }
                    }
                }
            }
            return resource;
        }
        catch (Exception e) {
            CorePlugin.logError(NLS.bind((String)Messages.Utility_BAD_SERIALIZED_INSTANCE, (Object[])new Object[]{identifableURI.toString()}), e);
            return null;
        }
    }

    public static Identifiable getIdentifiableIgnoreException(URI identifableURI) {
        EList cont;
        Identifiable retValue;
        block4: {
            retValue = null;
            URI normalized = STEMURI.normalize(identifableURI);
            Resource resource = null;
            ResourceSetImpl rs = new ResourceSetImpl();
            resource = rs.getResource(normalized, true);
            cont = resource.getContents();
            if (cont.size() != 0) break block4;
            int maxretry = 10;
            while (cont.size() == 0 && --maxretry > 0) {
                Thread.yield();
            }
            if (cont.size() != 0) break block4;
            return null;
        }
        try {
            retValue = (Identifiable)cont.get(0);
        }
        catch (Exception exception) {
            retValue = null;
        }
        return retValue;
    }

    public static void serializeIdentifiable(Identifiable identifiable, URI serializationURI) throws IOException {
        ArrayList<Identifiable> set = new ArrayList<Identifiable>();
        set.add(identifiable);
        Utility.serializeIdentifiables(set, serializationURI);
    }

    public static void serializeIdentifiableKeepDefaults(Identifiable identifiable, URI serializationURI) throws IOException {
        ArrayList<Identifiable> set = new ArrayList<Identifiable>();
        set.add(identifiable);
        Utility.serializeIdentifiablesKeepDefaults(set, serializationURI);
    }

    public static void serializeIdentifiables(List<Identifiable> identifiables, URI serializationURI) throws IOException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        rs.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource resource = rs.createResource(serializationURI);
        for (Identifiable id : identifiables) {
            resource.getContents().add((Object)id);
        }
        resource.save(EMF_SAVE_OPTIONS);
    }

    public static void serializeIdentifiablesKeepDefaults(List<Identifiable> identifiables, URI serializationURI) throws IOException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        rs.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource resource = rs.createResource(serializationURI);
        for (Identifiable id : identifiables) {
            resource.getContents().add((Object)id);
        }
        resource.save(EMF_SAVE_OPTIONS_KEEP_DEFAULTS);
    }

    public static void serializeIdentifiableToStream(Identifiable identifiable, URI serializationURI, OutputStream stream, Map<String, Object> options, boolean binary) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (binary) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMBinaryResourceFactoryImpl.INSTANCE);
            resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMBinaryResourceFactoryImpl.INSTANCE);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
            resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        }
        Resource resource = resourceSet.createResource(serializationURI);
        resource.getContents().add((Object)identifiable);
        resource.save(stream, options);
    }

    public static int keyLevel(String key) {
        if (key == null || key.trim().equals("")) {
            return -2;
        }
        if (key.equalsIgnoreCase("ZZZ")) {
            return -1;
        }
        int level = 0;
        int start = 0;
        int temp = key.indexOf("-");
        while (temp > 0) {
            ++level;
            temp = key.substring(start += temp + 1).indexOf("-");
        }
        return level;
    }

    public static void handleException(final String message, boolean promptUser, ScenarioInitializationException se) {
        CorePlugin.logError(se.getErrorMessage(), se.getOriginalException());
        if (promptUser && Display.getDefault() != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        String[] labels = new String[]{Messages.Utility_OKAY};
                        MessageDialog dialog = new MessageDialog(window.getShell(), "Warning", null, message, 1, labels, 0){};
                        dialog.open();
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }

    public static List<URI> findReferences(Identifiable ident) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] allProjects = workspaceRoot.getProjects();
        ArrayList<URI> result = new ArrayList<URI>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Utility.fetchDependenciesInProject(project, ident, result);
            ++n2;
        }
        return result;
    }

    private static void fetchDependenciesInProject(IProject project, Identifiable ident, List<URI> result) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = project.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof Folder && INCLUDE_FOLDERS.contains(member.getName())) {
                Utility.checkDependenciesInFolder(project, (Folder)member, ident, result);
            }
            ++n2;
        }
    }

    private static void checkDependenciesInFolder(IProject project, Folder f, Identifiable ident, List<URI> result) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = f.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource m = iResourceArray[n2];
            if (m instanceof File) {
                File file = (File)m;
                file.getFullPath().toPortableString();
                if (file.exists() && !file.isHidden() && !file.getName().startsWith(".") && !file.getName().equals(ident.getURI().lastSegment())) {
                    Utility.checkFile(project, file, ident, result);
                }
            }
            ++n2;
        }
    }

    private static void checkFile(IProject project, File file, Identifiable ident, List<URI> result) throws CoreException {
        InputStream content = file.getContents();
        BufferedReader bReader = new BufferedReader(new InputStreamReader(content));
        StringBuffer sbfFileContents = new StringBuffer();
        char[] c = new char[1024];
        int nc = -1;
        do {
            try {
                nc = bReader.read(c);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            if (nc == -1) continue;
            String s = new String(c, 0, nc);
            sbfFileContents.append(s);
        } while (nc != -1);
        String fileContent = sbfFileContents.toString();
        boolean needsUpdate = fileContent.contains(ident.getURI().toString());
        if (needsUpdate) {
            result.add(STEMURI.createFromFile(file));
        }
    }
}

