/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.bundle.Bundle;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.osgi.framework.BundleException;

public abstract class BundleModel
extends AbstractModel
implements IBundleModel {
    private static final long serialVersionUID = 1L;
    private Bundle fBundle = new Bundle();

    public BundleModel() {
        this.fBundle.setModel(this);
    }

    @Override
    public IBundle getBundle() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.fBundle;
    }

    @Override
    public String getInstallLocation() {
        return null;
    }

    @Override
    public abstract void load();

    @Override
    public boolean isFragmentModel() {
        return this.fBundle.getHeader("Fragment-Host") != null;
    }

    @Override
    public void load(InputStream source, boolean outOfSync) {
        try {
            this.setLoaded(true);
            this.fBundle.load(ManifestElement.parseBundleManifest((InputStream)source, null));
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (BundleException e) {
            PDECore.log(e);
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    public void load(BundleDescription desc, PDEState state) {
        String[] libraries;
        long id = desc.getBundleId();
        Properties properties = new Properties();
        properties.put("Bundle-SymbolicName", desc.getSymbolicName());
        String value = state.getPluginName(id);
        if (value != null) {
            properties.put("Bundle-Name", value);
        }
        if ((value = state.getProviderName(id)) != null) {
            properties.put("Bundle-Vendor", value);
        }
        if ((value = state.getClassName(id)) != null) {
            properties.put("Bundle-Activator", value);
        }
        if ((value = state.getBundleLocalization(id)) != null) {
            properties.put("Bundle-Localization", value);
        }
        if (state.hasExtensibleAPI(id)) {
            properties.put("Eclipse-ExtensibleAPI", "true");
        }
        if (state.isPatchFragment(id)) {
            properties.put("Eclipse-PatchFragment", "true");
        }
        if ((libraries = state.getLibraryNames(id)).length > 0) {
            StringBuilder buffer = new StringBuilder();
            String[] stringArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                if (buffer.length() > 0) {
                    buffer.append(",");
                    buffer.append(System.getProperty("line.separator"));
                    buffer.append(" ");
                }
                buffer.append(library);
                ++n2;
            }
            properties.put("Bundle-ClassPath", buffer.toString());
        }
        if (desc.getHost() != null) {
            properties.put("Fragment-Host", this.writeFragmentHost(desc.getHost()));
        }
        this.setLoaded(true);
        this.fBundle.load(properties);
        this.updateTimeStamp();
    }

    private String writeFragmentHost(HostSpecification host) {
        String id = host.getName();
        String version = host.getVersionRange().toString();
        StringBuilder buffer = new StringBuilder();
        if (id != null) {
            buffer.append(id);
        }
        if (version != null && version.trim().length() > 0) {
            buffer.append(";bundle-version=\"" + version + "\"");
        }
        return buffer.toString();
    }

    @Override
    public void reload(InputStream source, boolean outOfSync) {
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[0], null));
    }

    public String toString() {
        if (this.fBundle != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.fBundle.getHeader("Bundle-SymbolicName"));
            buf.append(" (");
            buf.append(this.fBundle.getHeader("Bundle-Version"));
            buf.append(')');
            return buf.toString();
        }
        return "Unknown bundle model";
    }
}

