/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.graphmap.GraphMapControl;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.stem.ui.views.graphmap.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GraphMapViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListener {
    private Set<ISimulation> simulationsToDisplay = new LinkedHashSet<ISimulation>();
    private SimulationManager simulationManager;
    private Composite composite;
    private Composite graphMapsComposite;
    private GraphMapView view;

    public GraphMapViewer(Composite parent, GraphMapView view) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.view = view;
        Composite buttonBar = new Composite(this.composite, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonBar.setLayout((Layout)new RowLayout());
        Button addViewButton = new Button(buttonBar, 8);
        addViewButton.setText(Messages.getString("IMView.AddView"));
        addViewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                int i = 1;
                while (true) {
                    if (page.findViewReference("org.eclipse.stem.ui.views.graphmap", "" + i) == null) {
                        try {
                            page.showView("org.eclipse.stem.ui.views.graphmap", "" + i, 1);
                        }
                        catch (PartInitException e1) {
                            Activator.logError("Could not instantiate new GraphMapView", e1);
                        }
                        break;
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.graphMapsComposite = new Composite(this.composite, 0);
        this.graphMapsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphMapsComposite.setLayout((Layout)new FillLayout(256));
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.graphMapsComposite;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            this.simulationsToDisplay.clear();
            this.simulationsToDisplay.addAll(this.simulationManager.getActiveSimulations());
        }
        this.populateView();
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object input) {
        SimulationManager oldInput = this.simulationManager;
        this.simulationManager = (SimulationManager)input;
        this.inputChanged(input, oldInput);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null) {
            ((SimulationManager)oldInput).removeListener((ISimulationManagerListener)this);
        }
        if (input != null) {
            ((SimulationManager)input).addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event);
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        this.simulationsToDisplay.addAll(Arrays.asList(event.getSimulationsAdded()));
        this.simulationsToDisplay.removeAll(Arrays.asList(event.getSimulationsRemoved()));
        this.populateView();
    }

    private void populateView() {
        ISimulation simulation;
        GraphMapControl geoControl;
        Control element;
        Control[] controls;
        if (this.graphMapsComposite.isDisposed()) {
            return;
        }
        HashSet<ISimulation> undisplayedSimulations = new HashSet<ISimulation>();
        for (ISimulation simulation2 : this.simulationsToDisplay) {
            if (this.isDisplayed(simulation2)) continue;
            undisplayedSimulations.add(simulation2);
        }
        Control[] controlArray = controls = this.graphMapsComposite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            geoControl = (GraphMapControl)element;
            if (!this.simulationsToDisplay.contains(geoControl.getSimulation()) && !undisplayedSimulations.isEmpty()) {
                simulation = (ISimulation)undisplayedSimulations.toArray()[0];
                geoControl.setSimulation(simulation);
                undisplayedSimulations.remove(simulation);
            }
            ++n2;
        }
        controlArray = controls;
        n = controls.length;
        n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            geoControl = (GraphMapControl)element;
            simulation = geoControl.getSimulation();
            if (simulation != null && !this.simulationsToDisplay.contains(simulation)) {
                geoControl.removeSelectionChangedListener(this);
                geoControl.dispose();
            }
            ++n2;
        }
        for (ISimulation simulation2 : undisplayedSimulations) {
            GraphMapControl geoControl2 = new GraphMapControl(this.graphMapsComposite, 0, this.view);
            geoControl2.addSelectionChangedListener(this);
            geoControl2.setSimulation(simulation2);
        }
        if (this.graphMapsComposite.getChildren().length == 0) {
            GraphMapControl geoControl3 = new GraphMapControl(this.graphMapsComposite, 0, this.view);
            geoControl3.addSelectionChangedListener(this);
        }
        this.graphMapsComposite.layout(true, true);
        this.graphMapsComposite.redraw();
    }

    private boolean isDisplayed(ISimulation simulation) {
        Control[] foo;
        boolean retValue = false;
        Control[] controlArray = foo = this.graphMapsComposite.getChildren();
        int n = foo.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            GraphMapControl geoControl = (GraphMapControl)element;
            ISimulation testSimulation = geoControl.getSimulation();
            if (testSimulation != null && testSimulation.equals(simulation)) {
                retValue = true;
                break;
            }
            ++n2;
        }
        return retValue;
    }
}

