/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestRequest;

abstract class TestDefinition {
    protected String ifProperty;
    protected String unlessProperty;
    protected Boolean haltOnFailure;
    protected String failureProperty;
    protected String outputDir;
    protected String includeEngines;
    protected String excludeEngines;
    protected List<ListenerDefinition> listeners = new ArrayList<ListenerDefinition>();

    TestDefinition() {
    }

    String getIfProperty() {
        return this.ifProperty;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    String getUnlessProperty() {
        return this.unlessProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    boolean isHaltOnFailure() {
        return this.haltOnFailure == null ? false : this.haltOnFailure;
    }

    Boolean getHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean haltonfailure) {
        this.haltOnFailure = haltonfailure;
    }

    String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void addConfiguredListener(ListenerDefinition listener) {
        this.listeners.add(listener);
    }

    List<ListenerDefinition> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    String getOutputDir() {
        return this.outputDir;
    }

    abstract List<TestRequest> createTestRequests(JUnitLauncherTask var1);

    protected boolean shouldRun(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)project);
        return propertyHelper.testIfCondition((Object)this.ifProperty) && propertyHelper.testUnlessCondition((Object)this.unlessProperty);
    }

    String[] getIncludeEngines() {
        return this.includeEngines == null ? new String[]{} : TestDefinition.split(this.includeEngines, ",");
    }

    public void setIncludeEngines(String includeEngines) {
        this.includeEngines = includeEngines;
    }

    String[] getExcludeEngines() {
        return this.excludeEngines == null ? new String[]{} : TestDefinition.split(this.excludeEngines, ",");
    }

    public void setExcludeEngines(String excludeEngines) {
        this.excludeEngines = excludeEngines;
    }

    private static String[] split(String value, String delimiter) {
        if (value == null) {
            return new String[0];
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : value.split(delimiter)) {
            if (part.trim().isEmpty()) continue;
            parts.add(part);
        }
        return parts.toArray(new String[parts.size()]);
    }
}

