/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.loggers.csv.Activator;
import org.eclipse.stem.loggers.csv.CSVLogger;
import org.eclipse.stem.loggers.csv.logger.Constants;
import org.eclipse.stem.loggers.csv.logger.DelimetedFileSimulationLogger;
import org.eclipse.stem.loggers.csv.logger.DelimetedWriter;
import org.eclipse.stem.loggers.csv.logger.FileUtils;
import org.eclipse.stem.loggers.csv.logger.Messages;
import org.eclipse.stem.loggers.csv.logger.SimulationUtils;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;

public class DelimetedFileDecoratorLogger {
    public static final Comparator<Node> NODE_SORTER = new Comparator<Node>(){

        @Override
        public int compare(Node n1, Node n2) {
            String s1 = n1.getURI().toString();
            String s2 = n2.getURI().toString();
            return s1.compareTo(s2);
        }
    };
    private final List<String> EXCLUDED_NODES = new ArrayList<String>(Arrays.asList(Constants.EXCLUDED_NODE_DEFAULTS));
    private final Map<StateLevelMap, DelimetedWriter> logWriters = new HashMap<StateLevelMap, DelimetedWriter>();
    private final Map<Integer, List<Node>> sortedNodeList = new HashMap<Integer, List<Node>>();
    private final DelimetedFileSimulationLogger simulationLogger;
    protected final IntegrationDecorator decorator;
    private final CSVLogger logger;
    private File logDirectory;
    private Map<Node, Integer> nodeLevels;
    private String decoratorName;
    private TimeProvider timeProvider;
    private static final String NOT_SET = "null";
    private boolean logIntegers = false;
    private boolean beforeStart = true;
    private List<Integer> resolutionLevels;
    private Map<String, EList<String>> identifierProperties;
    private boolean setupComplete = false;

    public DelimetedFileDecoratorLogger(DelimetedFileSimulationLogger simulationLogger, IntegrationDecorator decorator) {
        this.simulationLogger = simulationLogger;
        this.decorator = decorator;
        this.logger = simulationLogger.getLogger();
        URI baseDecoratorURI = decorator.getURI().trimQuery();
        this.identifierProperties = this.logger.getDecoratorProperties(baseDecoratorURI);
    }

    public DelimetedFileDecoratorLogger(DelimetedFileSimulationLogger simulationLogger, IntegrationDecorator decorator, boolean noSummaries) {
        this.simulationLogger = simulationLogger;
        this.decorator = decorator;
        this.logger = simulationLogger.getLogger();
        URI baseDecoratorURI = decorator.getURI().trimQuery();
        this.identifierProperties = this.logger.getDecoratorProperties(baseDecoratorURI);
        if (noSummaries) {
            this.logger.setLogHtmlSummary(false);
            this.logger.setLogRunParameters(false);
        }
    }

    public void start() {
        this.setupPropertyLoggers();
        this.setupComplete = true;
    }

    public void stop() {
        this.flush();
        for (DelimetedWriter fw : this.logWriters.values()) {
            FileUtils.safeClose(fw);
        }
        this.logWriters.clear();
        this.nodeLevels = null;
    }

    public void flush() {
        for (DelimetedWriter fw : this.logWriters.values()) {
            try {
                fw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void log() {
        if (!this.setupComplete) {
            this.start();
        }
        int stepNumber = this.getSequencer().getCycle();
        Set<String> decoratorPopulations = this.identifierProperties.keySet();
        for (Integer resolution : this.getResolutionLevels()) {
            for (Node node : this.getSortedNodesForAdminlevel(resolution, this.nodeLevels)) {
                for (String populationIdentifier : decoratorPopulations) {
                    EList<String> itemPropertiesToLog = this.identifierProperties.get(populationIdentifier);
                    NodeLabel label = this.getMatchingLabel(node, populationIdentifier);
                    if (label == null || !(label instanceof IntegrationLabel)) continue;
                    IntegrationLabel dmLabel = (IntegrationLabel)label;
                    IntegrationLabelValue labelValue = (IntegrationLabelValue)dmLabel.getCurrentValue();
                    for (IItemPropertyDescriptor itemDescriptor : this.getPropertiesForLabel((DynamicLabel)dmLabel)) {
                        StateLevelMap key;
                        DelimetedWriter fw;
                        if (!itemPropertiesToLog.contains((Object)itemDescriptor.getId(null)) || (fw = this.logWriters.get(key = new StateLevelMap(populationIdentifier, itemDescriptor.getDisplayName((Object)itemDescriptor), resolution))) == null) continue;
                        try {
                            if (fw.isEmptyLine()) {
                                fw.writeEntry(stepNumber);
                                fw.writeEntry(Constants.LOG_DATE_FORMATTER.format(this.getScenarioTime().getTime()));
                            }
                            EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(null);
                            double value = (Double)labelValue.eGet(feature);
                            if (this.logIntegers) {
                                fw.writeEntry((int)Math.rint(value));
                                continue;
                            }
                            fw.writeEntry(value);
                        }
                        catch (IOException ioe) {
                            Activator.logError(Messages.DFDL_LogFileWriteError, ioe);
                            FileUtils.safeClose(fw);
                            this.logWriters.remove(key);
                        }
                    }
                }
            }
        }
        this.appendLineToLogWriters();
        if (this.beforeStart) {
            this.beforeStart = false;
        }
    }

    private void appendLineToLogWriters() {
        Iterator<Map.Entry<StateLevelMap, DelimetedWriter>> writers = this.logWriters.entrySet().iterator();
        while (writers.hasNext()) {
            DelimetedWriter fw = writers.next().getValue();
            if (fw.isEmptyLine()) continue;
            try {
                fw.newLine();
            }
            catch (IOException ioe) {
                Activator.logError(Messages.DFDL_LogFileWriteError, ioe);
                FileUtils.safeClose(fw);
                writers.remove();
            }
        }
    }

    private String getDecoratorName() {
        if (this.decoratorName == null) {
            this.decoratorName = this.decorator instanceof DiseaseModel ? ((DiseaseModel)this.decorator).getDiseaseName().trim() : (this.decorator instanceof PopulationModel ? ((PopulationModel)this.decorator).getName().trim() : this.decorator.eClass().toString());
        }
        return this.decoratorName;
    }

    public CSVLogger getLogger() {
        return this.logger;
    }

    protected File getLogDirectory() {
        if (this.logDirectory == null) {
            this.logDirectory = new File(this.simulationLogger.getLogDirectory(), this.getDecoratorName());
            if (!this.logDirectory.exists() && !this.logDirectory.mkdirs()) {
                Activator.logError(String.valueOf(Messages.DFDL_CreateDirectoryError) + this.getDecoratorName(), new IOException(String.valueOf(Messages.DFDL_CreateDirectoryException) + this.logDirectory.getAbsolutePath()));
            }
        }
        return this.logDirectory;
    }

    private File getRunParametersFile() {
        return new File(this.getLogDirectory(), "runparameters.csv");
    }

    private STEMTime getScenarioTime() {
        STEMTime time = this.getTimeProvider().getTime();
        if (time == null) {
            time = this.getSequencer().getStartTime();
        }
        if (!this.beforeStart) {
            time = time.addIncrement(this.getSequencer().getTimeDelta());
        }
        return time;
    }

    private Sequencer getSequencer() {
        return this.simulationLogger.getSimulation().getScenario().getSequencer();
    }

    protected void writeRunParameters() {
        block8: {
            if (this.decorator == null) {
                return;
            }
            DelimetedWriter fwp = null;
            try {
                try {
                    fwp = new DelimetedWriter(this.logger.getDelimeter(), this.logger.getBufferSize(), new FileWriter(this.getRunParametersFile()));
                    ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                    IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)this.decorator, IItemPropertySource.class);
                    List properties = propertySource.getPropertyDescriptors((Object)this.decorator);
                    ArrayList<String> header = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    for (IItemPropertyDescriptor descriptor : properties) {
                        EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                        if (CommonPackage.eINSTANCE.getDublinCore().equals(feature.getEContainingClass())) continue;
                        header.add(feature.getName());
                        Object target = this.decorator.eGet(feature);
                        if (target != null) {
                            String nextValue = target.toString().replace(",", "_");
                            values.add(nextValue);
                            continue;
                        }
                        values.add(NOT_SET);
                    }
                    fwp.writeLine(header);
                    fwp.writeLine(values);
                }
                catch (IOException e) {
                    Activator.logError(Messages.DFDL_WriteRunParametersError, e);
                    FileUtils.safeClose(fwp);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(fwp);
                throw throwable;
            }
            FileUtils.safeClose(fwp);
        }
    }

    private File getLogFileForProperty(String populationIdentifier, String decoratoryPropertyName, int adminLevel) {
        File populationDirectory = new File(this.getLogDirectory(), populationIdentifier);
        if (!populationDirectory.exists() && !populationDirectory.mkdirs()) {
            Activator.logWarning(String.valueOf(Messages.DFDL_CreatePopulationDirectoryError) + populationDirectory.toString(), null);
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(decoratoryPropertyName);
        fileName.append("_");
        fileName.append(adminLevel);
        fileName.append(".");
        fileName.append("csv");
        return new File(populationDirectory, fileName.toString());
    }

    private DelimetedWriter createLogger(String populationIdentifier, String propertyDisplayName, int adminLevel) {
        DelimetedWriter fw;
        block15: {
            File propertyLogFile = this.getLogFileForProperty(populationIdentifier, propertyDisplayName, adminLevel);
            fw = null;
            boolean fileHasData = false;
            try {
                try {
                    fw = new DelimetedWriter(this.logger.getDelimeter(), this.logger.getBufferSize(), new FileWriter(propertyLogFile));
                    fw.writeEntry("iteration");
                    fw.writeEntry("time");
                    for (Node node : this.getSortedNodesForAdminlevel(adminLevel, this.nodeLevels)) {
                        NodeLabel labelToWrite = this.getMatchingLabel(node, populationIdentifier);
                        if (labelToWrite == null) continue;
                        fileHasData = true;
                        fw.writeEntry(this.filterLocationId(node.getURI().toString()));
                    }
                    fw.newLine();
                }
                catch (IOException ioe) {
                    Activator.logError(String.valueOf(Messages.DFDL_LoggerCreateError) + propertyLogFile.toString(), ioe);
                    fileHasData = false;
                    if (!fileHasData) {
                        FileUtils.safeClose(fw);
                        fw = null;
                        try {
                            propertyLogFile.delete();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (!fileHasData) {
                    FileUtils.safeClose(fw);
                    fw = null;
                    try {
                        propertyLogFile.delete();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (!fileHasData) {
                FileUtils.safeClose(fw);
                fw = null;
                try {
                    propertyLogFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return fw;
    }

    private void setupPropertyLoggers() {
        this.nodeLevels = SimulationUtils.getNodeLevelsForScenario(this.simulationLogger.getSimulation().getScenario());
        IntegrationLabel label = this.getFirstLabelForDecorator();
        if (label == null) {
            Activator.logError(String.valueOf(Messages.DFDL_NoDecoratorLabels) + this.getDecoratorName(), new Exception());
            return;
        }
        List<IItemPropertyDescriptor> properties = this.getPropertiesForLabel((DynamicLabel)label);
        if (properties == null) {
            Activator.logError(String.valueOf(Messages.DFDL_NoLabelProperties) + label, null);
            return;
        }
        Set<String> populationIdentifiers = this.identifierProperties.keySet();
        if (populationIdentifiers == null) {
            Activator.logError(String.valueOf(Messages.DFDL_NoDecoratorPopulations) + this.getDecoratorName(), null);
            return;
        }
        for (String populationIdentifier : populationIdentifiers) {
            for (Integer level : this.getResolutionLevels()) {
                EList<String> itemPropertiesToLog = this.identifierProperties.get(populationIdentifier);
                for (IItemPropertyDescriptor decoratorProperty : properties) {
                    String propertyName;
                    DelimetedWriter fw;
                    if (!itemPropertiesToLog.contains((Object)decoratorProperty.getId(null)) || (fw = this.createLogger(populationIdentifier, propertyName = decoratorProperty.getDisplayName((Object)decoratorProperty), level)) == null) continue;
                    this.logWriters.put(new StateLevelMap(populationIdentifier, propertyName, level), fw);
                }
            }
        }
    }

    private IntegrationLabel getFirstLabelForDecorator() {
        for (DynamicLabel label : this.decorator.getLabelsToUpdate()) {
            if (!(label instanceof IntegrationLabel)) continue;
            return (IntegrationLabel)label;
        }
        return null;
    }

    private List<IItemPropertyDescriptor> getPropertiesForLabel(DynamicLabel label) {
        RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)label, RelativeValueProvider.class);
        return rvp.getProperties();
    }

    private List<Integer> getResolutionLevels() {
        if (this.resolutionLevels == null) {
            this.resolutionLevels = new ArrayList<Integer>();
            for (Integer level : this.nodeLevels.values()) {
                if (this.resolutionLevels.contains(level)) continue;
                this.resolutionLevels.add(level);
            }
        }
        return this.resolutionLevels;
    }

    private boolean isExcludedNode(Node node) {
        for (String key : this.EXCLUDED_NODES) {
            if (!node.getURI().toString().contains(key)) continue;
            return true;
        }
        return false;
    }

    private List<Node> getSortedNodesForAdminlevel(int level, Map<Node, Integer> nodeLevels) {
        List<Node> list = this.sortedNodeList.get(level);
        if (list == null) {
            list = new ArrayList<Node>();
            block0: for (Map.Entry<Node, Integer> entry : nodeLevels.entrySet()) {
                if (entry.getValue() != level) continue;
                Node node = entry.getKey();
                for (NodeLabel s : node.getLabels()) {
                    if (!(s instanceof IntegrationLabel)) continue;
                    if (this.isExcludedNode(node)) continue block0;
                    list.add(entry.getKey());
                    continue block0;
                }
            }
            Collections.sort(list, NODE_SORTER);
            this.sortedNodeList.put(level, list);
        }
        return list;
    }

    private NodeLabel getMatchingLabel(Node n, String popId) {
        for (NodeLabel label : n.getLabels()) {
            if (this.decorator instanceof DiseaseModel && label instanceof DiseaseModelLabel && ((DiseaseModelLabel)label).getDecorator().equals(this.decorator) && ((DiseaseModelLabel)label).getPopulationModelLabel().getPopulationIdentifier().equals(popId)) {
                return label;
            }
            if (!(this.decorator instanceof PopulationModel) || !(label instanceof PopulationModelLabel) || !((PopulationModelLabel)label).getDecorator().equals(this.decorator) || !((PopulationModelLabel)label).getPopulationIdentifier().equals(popId)) continue;
            return label;
        }
        return null;
    }

    private String filterLocationId(String unfiltered) {
        int last = unfiltered.indexOf("/node/geo/region/");
        if (last >= 0) {
            return unfiltered.substring(last += "/node/geo/region/".length(), unfiltered.length());
        }
        return unfiltered;
    }

    private TimeProvider getTimeProvider() {
        if (this.timeProvider == null) {
            this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.simulationLogger.getSimulation().getScenario().getCanonicalGraph(), TimeProvider.class);
        }
        return this.timeProvider;
    }

    private static class StateLevelMap {
        private final String popId;
        private final String state;
        private final int level;

        public StateLevelMap(String popId, String state, int level) {
            this.popId = popId;
            this.state = state;
            this.level = level;
        }

        public String getPopulationId() {
            return this.popId;
        }

        public int getLevel() {
            return this.level;
        }

        public String getState() {
            return this.state;
        }

        public int hashCode() {
            return this.state.hashCode() + this.popId.hashCode() + this.level;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StateLevelMap)) {
                return false;
            }
            StateLevelMap slm = (StateLevelMap)o;
            return slm.getState().equals(this.state) && slm.getPopulationId().equals(this.popId) && slm.getLevel() == this.level;
        }

        public String toString() {
            return String.valueOf(this.popId) + " - " + this.state + "_" + this.level;
        }
    }
}

