/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.manager;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.loggers.LOGGER_EVENTS;
import org.eclipse.stem.loggers.SimulationLogger;
import org.eclipse.stem.loggers.SimulationLoggerPackage;

public class LoggerAdapter
extends AdapterImpl
implements ISimulationListener,
ISimulationListenerSync {
    SimulationLogger logger;
    ISimulation simulation;
    int simulationStepMod;

    LoggerAdapter(ISimulation simulation, SimulationLogger logger) {
        this.logger = logger;
        this.simulation = simulation;
        this.simulationStepMod = logger.getStepMod();
        if (this.simulationStepMod < 1) {
            this.simulationStepMod = 1;
        }
        this.setTarget((Notifier)logger);
        logger.eAdapters().add((Object)this);
    }

    public void notifyChanged(Notification msg) {
        if (SimulationLoggerPackage.Literals.SIMULATION_LOGGER__ENABLED.equals(msg.getFeature())) {
            if (msg.getNewBooleanValue()) {
                this.fireLoggerEvent(LOGGER_EVENTS.LOGGER_ENABLED);
            } else {
                this.fireLoggerEvent(LOGGER_EVENTS.LOGGER_DISABLED);
            }
        }
    }

    public SimulationLogger getLogger() {
        return this.logger;
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    void fireLoggerEvent(LOGGER_EVENTS event) {
        this.logger.loggerEvent(this.simulation, event);
    }

    void fireSimulationEvent(SimulationEvent event) {
        int step = event.getSimulation().getScenario().getSequencer().getCycle();
        if (this.logger != null && this.logger.isEnabled() && (long)step >= this.logger.getStartStep() && step % this.simulationStepMod == 0) {
            this.logger.simulationEvent(event);
        }
    }

    public void simulationChangedSync(SimulationEvent event) {
        this.fireSimulationEvent(event);
    }

    public void simulationChanged(SimulationEvent event) {
        this.fireSimulationEvent(event);
    }

    void destroy() {
        this.setTarget(null);
        this.logger.eAdapters().remove((Object)this);
        this.logger = null;
        this.simulation = null;
    }
}

