/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.preferences;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.xtext.ui.editor.preferences.FixedScopedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.Messages;

public abstract class AbstractPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Logger log = Logger.getLogger(AbstractPreferencePage.class);
    private static final String USE_PROJECT_SETTINGS = "useProjectSettings";
    private IWorkbench workbench;
    private IProject project;
    private Button useProjectSettingsButton;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private Link link;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    @Named(value="languageName")
    private String languageName;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IProject.class);
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public boolean isPropertyPage() {
        return this.project != null;
    }

    public AbstractPreferencePage() {
        super(1);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.preferenceStoreAccess.getWritablePreferenceStore(this.currentProject());
        }
        return this.preferenceStoreAccess.getWritablePreferenceStore();
    }

    @Deprecated
    protected String getQualifier() {
        return this.qualifiedName();
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createUseProjectSettingsControls(parent);
        }
        return super.createContents(parent);
    }

    private void createUseProjectSettingsControls(Composite parent) {
        Composite projectSettingsParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        projectSettingsParent.setLayout((Layout)layout);
        projectSettingsParent.setLayoutData((Object)new GridData(768));
        this.useProjectSettingsButton = new Button(projectSettingsParent, 32);
        this.useProjectSettingsButton.setText(Messages.AbstractPreferencePage_useProjectSettings);
        this.useProjectSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferencePage.this.handleUseProjectSettings();
                log.debug((Object)"AbstractPreferencePage.widgetSelected()");
            }
        });
        this.link = new Link(projectSettingsParent, 0);
        this.link.setFont(projectSettingsParent.getFont());
        this.link.setText("<A>" + Messages.AbstractPreferencePage_configureWorkspaceSettings + "</A>");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = AbstractPreferencePage.this.qualifiedName();
                PreferencesUtil.createPreferenceDialogOn((Shell)AbstractPreferencePage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
                AbstractPreferencePage.this.updateFieldEditors(false);
            }
        });
        this.link.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        Label horizontalLine = new Label(projectSettingsParent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(projectSettingsParent.getFont());
        this.restoreOldSettings();
        this.useProjectSettingsButton.setSelection(this.isUseProjectSettings().booleanValue());
    }

    private void restoreOldSettings() {
        if (this.isPropertyPage()) {
            QualifiedName oldKey = new QualifiedName(this.qualifiedName(), USE_PROJECT_SETTINGS);
            try {
                String oldValue = this.currentProject().getPersistentProperty(oldKey);
                if (oldValue != null) {
                    this.currentProject().setPersistentProperty(oldKey, null);
                    if (Boolean.valueOf(oldValue).booleanValue()) {
                        this.saveUseProjectSettings(true);
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to read persistent property", (Throwable)e);
            }
        }
    }

    private IProject currentProject() {
        if (this.project == null) {
            throw new IllegalStateException("Not a property page case, but current project was requested.");
        }
        return this.project;
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    protected String qualifiedName() {
        return this.languageName;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.handleUseProjectSettings();
        }
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    private Boolean isUseProjectSettings() {
        return this.getPreferenceStore().getBoolean(this.useProjectSettingsPreferenceName());
    }

    protected String useProjectSettingsPreferenceName() {
        return String.valueOf(this.qualifiedName()) + "." + USE_PROJECT_SETTINGS;
    }

    private void handleUseProjectSettings() {
        boolean isUseProjectSettings = this.useProjectSettingsButton.getSelection();
        this.link.setEnabled(!isUseProjectSettings);
        if (!isUseProjectSettings) {
            ((FixedScopedPreferenceStore)this.getPreferenceStore()).setSearchContexts(new IScopeContext[]{new InstanceScope(), new ConfigurationScope()});
        } else {
            ((FixedScopedPreferenceStore)this.getPreferenceStore()).setSearchContexts(new IScopeContext[]{new ProjectScope(this.currentProject()), new InstanceScope(), new ConfigurationScope()});
            this.setProjectSpecificValues();
        }
        this.updateFieldEditors(isUseProjectSettings);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.load();
            editor.setEnabled(enabled, parent);
        }
        Button defaultsButton = this.getDefaultsButton();
        if (defaultsButton != null) {
            defaultsButton.setEnabled(enabled);
        }
    }

    public boolean performOk() {
        boolean retVal = super.performOk();
        if (retVal && this.isPropertyPage()) {
            try {
                this.saveUseProjectSettings(this.useProjectSettingsButton.getSelection());
            }
            catch (Exception e) {
                log.error((Object)"Error", (Throwable)e);
                retVal = false;
            }
        }
        return retVal;
    }

    private void saveUseProjectSettings(boolean isProjectSpecific) throws IOException {
        FixedScopedPreferenceStore store = (FixedScopedPreferenceStore)this.getPreferenceStore();
        if (!isProjectSpecific) {
            IEclipsePreferences storePreferences = store.getStorePreferences();
            for (FieldEditor field : this.editors) {
                storePreferences.remove(field.getPreferenceName());
            }
            storePreferences.remove(this.useProjectSettingsPreferenceName());
        } else {
            store.setValue(this.useProjectSettingsPreferenceName(), Boolean.toString(isProjectSpecific));
        }
        store.save();
    }

    private void setProjectSpecificValues() {
        FixedScopedPreferenceStore store = (FixedScopedPreferenceStore)this.getPreferenceStore();
        IEclipsePreferences storePreferences = store.getStorePreferences();
        for (FieldEditor field : this.editors) {
            String key = field.getPreferenceName();
            storePreferences.put(key, store.getString(key));
        }
    }
}

