/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DisplaySafeExecutor {
    private static Display display = null;
    private static boolean displayInit = false;

    public static boolean isRunningOnUIThread() {
        Display d = DisplaySafeExecutor.safeGetDefaultDisplay();
        return d != null && d.getThread() == Thread.currentThread();
    }

    public static synchronized void forceHeadless() {
        if (display != null) {
            try {
                display.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        display = null;
        displayInit = true;
    }

    public static Display safeGetDefaultDisplay() {
        return DisplaySafeExecutor.safeGetDefaultDisplay(false);
    }

    public static synchronized Display safeGetDefaultDisplay(boolean reinit) {
        if (reinit || display == null && !displayInit) {
            try {
                display = Display.getDefault();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            displayInit = true;
        }
        if (display != null && display.isDisposed()) {
            display = null;
        }
        return display;
    }

    public static void executeSync(Runnable runnable) {
        DisplaySafeExecutor.executeSync(runnable, false);
    }

    public static void executeSync(Runnable runnable, boolean headlessSafe) {
        if (runnable == null) {
            return;
        }
        Display d = null;
        if (!headlessSafe) {
            d = DisplaySafeExecutor.safeGetDefaultDisplay();
        }
        if (d != null) {
            d.syncExec(runnable);
        } else {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void executeAsync(Runnable runnable) {
        DisplaySafeExecutor.executeAsync(runnable, false);
    }

    public static void executeAsync(final Runnable runnable, boolean headlessSafe) {
        if (runnable == null) {
            return;
        }
        Display d = null;
        if (!headlessSafe) {
            d = DisplaySafeExecutor.safeGetDefaultDisplay();
        }
        if (d != null) {
            d.asyncExec(runnable);
        } else {
            new Job(runnable.toString()){

                protected IStatus run(IProgressMonitor monitor) {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

