/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;

@ImplementedBy(value=RuleBasedNameValidator.class)
public interface IRenameNameValidator {
    public void validate(EObject var1, String var2, RefactoringIssueAcceptor var3);

    public static class RuleBasedNameValidator
    implements IRenameNameValidator {
        @Inject
        private IValueConverterService valueConverterService;

        @Override
        public void validate(EObject target, String newName, RefactoringIssueAcceptor issues) {
            try {
                this.getNameAsValue(newName);
            }
            catch (Throwable _t) {
                if (_t instanceof ValueConverterException) {
                    ValueConverterException e = (ValueConverterException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Illegal name: ");
                    String _message = e.getMessage();
                    _builder.append(_message);
                    issues.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        protected String getNameAsText(String nameAsValue) {
            return this.valueConverterService.toString((Object)nameAsValue, this.getRuleName());
        }

        protected String getNameAsValue(String nameAsText) {
            return this.valueConverterService.toValue(nameAsText, this.getRuleName(), null).toString();
        }

        protected String getRuleName() {
            return "ID";
        }
    }
}

