/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.scoping;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stem.model.ctdl.CTDLUtils;
import org.eclipse.stem.model.ctdl.ctdl.CtdlFactory;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.functions.ExternalFunctionDefinition;
import org.eclipse.stem.model.ctdl.functions.FunctionArgument;
import org.eclipse.stem.model.ctdl.functions.FunctionDefinitionLoader;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public class ExtensionAwareScope
extends AbstractScope {
    final Map<String, List<ExternalFunctionDefinition>> functionDefinitions;
    final List<IEObjectDescription> addedOn;
    private static final Map<String, Set<String>> alternateTypes = new HashMap<String, Set<String>>();

    static {
        alternateTypes.put("compartment", Sets.newHashSet((Object[])new String[]{"compartment", "number"}));
    }

    public ExtensionAwareScope(IScope delegate, EObject ctx) {
        super(delegate, true);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createURI((String)"empty.sctd"));
        this.functionDefinitions = FunctionDefinitionLoader.getInstance().getDefinitions();
        this.addedOn = new ArrayList<IEObjectDescription>();
        for (List<ExternalFunctionDefinition> functionsByName : this.functionDefinitions.values()) {
            for (ExternalFunctionDefinition function : functionsByName) {
                ExternalFunctionReference ref = CtdlFactory.eINSTANCE.createExternalFunctionReference();
                ref.setFunc(function);
                ref.setName(function.getName());
                resource.getContents().add((Object)ref);
                this.addedOn.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)this.getSignatureForFunctionDefinition(function)), (EObject)ref));
            }
        }
    }

    private String getSignatureForFunctionDefinition(ExternalFunctionDefinition def) {
        StringBuilder sb = new StringBuilder();
        sb.append(def.getName());
        sb.append("(");
        EList args = def.getFunctionArguments();
        int paramCount = args.size();
        int idx = 0;
        while (idx < args.size()) {
            sb.append(CTDLUtils.getNormalizedTypeNameForClass(((FunctionArgument)args.get(idx)).getType()));
            if (idx < paramCount - 1) {
                sb.append(",");
            }
            ++idx;
        }
        sb.append(")");
        return sb.toString();
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        return this.addedOn;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(EObject object, URI uri) {
        return super.getLocalElementsByEObject(object, uri);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return super.getSingleElement(object);
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription element = null;
        for (QualifiedName candidate : this.getSearchCandidates(name)) {
            element = super.getSingleElement(candidate);
            if (element != null) break;
        }
        return element;
    }

    private List<String> splitSignatureSegments(QualifiedName name) {
        String signature = name.getLastSegment();
        int p1 = signature.indexOf(40);
        int p2 = signature.indexOf(41);
        ArrayList<String> segments = new ArrayList<String>();
        if (p1 < 0 || p2 < 0) {
            segments.add(signature);
            return segments;
        }
        String functionName = signature.substring(0, p1);
        segments.add(functionName);
        String args = signature.substring(p1 + 1, p2).trim();
        if (!"".equals(args)) {
            segments.addAll(Arrays.asList(args.split(",")));
        }
        return segments;
    }

    private List<QualifiedName> getSearchCandidates(QualifiedName name) {
        LinkedList<QualifiedName> candidates = new LinkedList<QualifiedName>();
        candidates.add(name);
        List<String> segments = this.splitSignatureSegments(name);
        String functionName = segments.get(0);
        if (segments.size() > 1) {
            ArrayList<Set<String>> segmentCandidates = new ArrayList<Set<String>>();
            int idx = 1;
            while (idx < segments.size()) {
                String type = segments.get(idx);
                Set<String> alts = alternateTypes.get(type);
                if (alts != null) {
                    segmentCandidates.add(alts);
                } else {
                    segmentCandidates.add(Sets.newHashSet((Object[])new String[]{type}));
                }
                ++idx;
            }
            Set combinations = Sets.cartesianProduct(segmentCandidates);
            for (List combo : combinations) {
                StringBuilder sb = new StringBuilder();
                sb.append(functionName);
                sb.append("(");
                boolean first = true;
                for (String arg0 : combo) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(arg0);
                }
                sb.append(")");
                QualifiedName candidate = QualifiedName.create((String)sb.toString());
                candidates.add(candidate);
            }
        }
        return candidates;
    }
}

