/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;

public class TransitionReconnectCommand
extends Command {
    private TransitionElement transition;
    private CompartmentElement newSource;
    private CompartmentElement newTarget;
    private CompartmentElement oldSource;
    private CompartmentElement oldTarget;

    public TransitionReconnectCommand(TransitionElement transition) {
        this.transition = transition;
        this.oldSource = transition.getSource();
        this.oldTarget = transition.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        for (TransitionElement te : this.newSource.getSourceTransitions()) {
            if (te.getSource() == null || te.getTarget() == null || te == this.transition || !te.getTarget().equals(this.oldTarget)) continue;
            return false;
        }
        return this.isValid(this.newSource, this.oldTarget);
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        for (TransitionElement te : this.newTarget.getSourceTransitions()) {
            if (te.getSource() == null || te.getSource() == null || te == this.transition || !te.getSource().equals(this.oldSource)) continue;
            return false;
        }
        return this.isValid(this.oldSource, this.newTarget);
    }

    public void execute() {
        if (this.newSource != null && this.isValid(this.newSource, this.oldTarget)) {
            this.transition.updateConnections(this.newSource, this.oldTarget);
            this.oldSource.eNotify(null);
            this.oldTarget.eNotify(null);
            this.newSource.eNotify(null);
        } else if (this.newTarget != null && this.isValid(this.oldSource, this.newTarget)) {
            this.transition.updateConnections(this.oldSource, this.newTarget);
            this.oldSource.eNotify(null);
            this.oldTarget.eNotify(null);
            this.newTarget.eNotify(null);
        }
    }

    private boolean isValid(CompartmentElement source, CompartmentElement target) {
        if (source.getCompartment().getType() != CompartmentType.STANDARD) {
            return false;
        }
        return target.getCompartment().getType() == CompartmentType.STANDARD || target.getCompartment().getType() == CompartmentType.DEATHS;
    }

    public void setNewSource(CompartmentElement connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection startpoint");
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(CompartmentElement connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection endpoint");
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.transition.setSource(this.oldSource);
        this.transition.setTarget(this.oldTarget);
    }
}

