/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider2;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class SafeDelegateTreeContentProvider
implements IPipelinedTreeContentProvider2,
ITreePathContentProvider {
    private static final TreePath[] NO_PATHS = new TreePath[0];
    private final ITreeContentProvider contentProvider;
    private StructuredViewer viewer;

    SafeDelegateTreeContentProvider(ITreeContentProvider aContentProvider) {
        this.contentProvider = aContentProvider;
    }

    public boolean isPipelined() {
        return this.contentProvider instanceof IPipelinedTreeContentProvider;
    }

    public boolean isPipelinedHasChildren() {
        return this.contentProvider instanceof IPipelinedTreeContentProvider2;
    }

    public boolean isTreePath() {
        return this.contentProvider instanceof ITreePathContentProvider;
    }

    public void dispose() {
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                SafeDelegateTreeContentProvider.this.contentProvider.dispose();
            }
        });
    }

    public boolean equals(Object anObject) {
        return this.contentProvider.equals(anObject);
    }

    public Object[] getChildren(Object aParentElement) {
        if (aParentElement instanceof TreePath) {
            TreePath tp = (TreePath)aParentElement;
            return this.getChildren(tp);
        }
        Object[] children = this.contentProvider.getChildren(aParentElement);
        return children;
    }

    public Object[] getElements(Object anInputElement) {
        Object[] elements = this.contentProvider.getElements(anInputElement);
        return elements;
    }

    public Object getParent(Object anElement) {
        return this.contentProvider.getParent(anElement);
    }

    public boolean hasChildren(Object anElement) {
        return this.contentProvider.hasChildren(anElement);
    }

    public int hashCode() {
        return this.contentProvider.hashCode();
    }

    public void inputChanged(final Viewer aViewer, final Object anOldInput, final Object aNewInput) {
        this.viewer = (StructuredViewer)aViewer;
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                SafeDelegateTreeContentProvider.this.contentProvider.inputChanged(aViewer, anOldInput, aNewInput);
            }
        });
    }

    public String toString() {
        return this.contentProvider.toString();
    }

    public ITreeContentProvider getDelegateContentProvider() {
        return this.contentProvider;
    }

    @Override
    public void restoreState(IMemento aMemento) {
        if (this.contentProvider != null && this.contentProvider instanceof IMementoAware) {
            ((IMementoAware)this.contentProvider).restoreState(aMemento);
        }
    }

    @Override
    public void saveState(IMemento aMemento) {
        if (this.contentProvider != null && this.contentProvider instanceof IMementoAware) {
            ((IMementoAware)this.contentProvider).saveState(aMemento);
        }
    }

    @Override
    public void init(ICommonContentExtensionSite aConfig) {
        if (this.contentProvider instanceof ICommonContentProvider) {
            ((ICommonContentProvider)this.contentProvider).init(aConfig);
        }
    }

    @Override
    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedChildren(aParent, theCurrentChildren);
        }
    }

    @Override
    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedElements(anInput, theCurrentElements);
        }
    }

    @Override
    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedParent(anObject, aSuggestedParent);
        }
        return anObject;
    }

    @Override
    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).interceptAdd(anAddModification);
        }
        return anAddModification;
    }

    @Override
    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).interceptRemove(aRemoveModification);
        }
        return aRemoveModification;
    }

    @Override
    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).interceptRefresh(aRefreshSynchronization);
        }
        return false;
    }

    @Override
    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).interceptUpdate(anUpdateSynchronization);
        }
        return false;
    }

    public Object[] getChildren(TreePath parentPath) {
        if (this.contentProvider instanceof ITreePathContentProvider) {
            ITreePathContentProvider tpcp = (ITreePathContentProvider)this.contentProvider;
            Object[] children = tpcp.getChildren(parentPath);
            return children;
        }
        return this.getChildren(parentPath.getLastSegment());
    }

    public boolean hasChildren(TreePath path) {
        if (this.contentProvider instanceof ITreePathContentProvider) {
            ITreePathContentProvider tpcp = (ITreePathContentProvider)this.contentProvider;
            return tpcp.hasChildren(path);
        }
        return this.hasChildren(path.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        if (this.contentProvider instanceof ITreePathContentProvider) {
            ITreePathContentProvider tpcp = (ITreePathContentProvider)this.contentProvider;
            return tpcp.getParents(element);
        }
        ArrayList<Object> segments = new ArrayList<Object>();
        Object parent = element;
        do {
            if ((parent = this.contentProvider.getParent(parent)) == null || parent == this.viewer.getInput()) continue;
            segments.add(0, parent);
        } while (parent != null && parent != this.viewer.getInput());
        if (!segments.isEmpty()) {
            return new TreePath[]{new TreePath(segments.toArray())};
        }
        return NO_PATHS;
    }

    @Override
    public boolean hasPipelinedChildren(Object anInput, boolean currentHasChildren) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider2) {
            return ((IPipelinedTreeContentProvider2)this.contentProvider).hasPipelinedChildren(anInput, currentHasChildren);
        }
        return currentHasChildren;
    }
}

