/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelLabelValueImpl;

public abstract class StandardDiseaseModelLabelValueImpl
extends DiseaseModelLabelValueImpl
implements StandardDiseaseModelLabelValue {
    protected static final double S_EDEFAULT = 0.0;
    protected double s = 0.0;
    protected static final double INCIDENCE_EDEFAULT = 0.0;
    protected double incidence = 0.0;
    protected static final double DISEASE_DEATHS_EDEFAULT = 0.0;
    protected double diseaseDeaths = 0.0;

    public StandardDiseaseModelLabelValueImpl() {
    }

    public StandardDiseaseModelLabelValueImpl(double s, double incidence, double diseaseDeaths) {
        this.setS(s);
        this.setIncidence(incidence);
        this.setDiseaseDeaths(diseaseDeaths);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_DISEASE_MODEL_LABEL_VALUE;
    }

    @Override
    public double getS() {
        return this.s;
    }

    @Override
    public void setS(double newS) {
        this.s = newS;
    }

    @Override
    public double getIncidence() {
        return this.incidence;
    }

    @Override
    public void setIncidence(double newIncidence) {
        this.incidence = newIncidence;
    }

    @Override
    public double getDiseaseDeaths() {
        return this.diseaseDeaths;
    }

    @Override
    public void setDiseaseDeaths(double newDiseaseDeaths) {
        this.diseaseDeaths = newDiseaseDeaths;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getS();
            }
            case 4: {
                return this.getIncidence();
            }
            case 5: {
                return this.getDiseaseDeaths();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setS((Double)newValue);
                return;
            }
            case 4: {
                this.setIncidence((Double)newValue);
                return;
            }
            case 5: {
                this.setDiseaseDeaths((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setS(0.0);
                return;
            }
            case 4: {
                this.setIncidence(0.0);
                return;
            }
            case 5: {
                this.setDiseaseDeaths(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.s != 0.0;
            }
            case 4: {
                return this.incidence != 0.0;
            }
            case 5: {
                return this.diseaseDeaths != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (s: ");
        result.append(this.s);
        result.append(", incidence: ");
        result.append(this.incidence);
        result.append(", diseaseDeaths: ");
        result.append(this.diseaseDeaths);
        result.append(')');
        return result.toString();
    }

    public IntegrationLabelValue set(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        this.setS(v.getS());
        this.setIncidence(v.getIncidence());
        this.setDiseaseDeaths(v.getDiseaseDeaths());
        return this;
    }

    public IntegrationLabelValue add(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        this.setS(this.getS() + v.getS());
        this.setIncidence(this.getIncidence() + v.getIncidence());
        this.setDiseaseDeaths(this.getDiseaseDeaths() + v.getDiseaseDeaths());
        return this;
    }

    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        this.setS(this.getS() - v.getS());
        this.setIncidence(this.getIncidence() - v.getIncidence());
        this.setDiseaseDeaths(this.getDiseaseDeaths() - v.getDiseaseDeaths());
        return this;
    }

    public IntegrationLabelValue scale(double scaleFactor) {
        this.setS(scaleFactor * this.getS());
        this.setIncidence(scaleFactor * this.getIncidence());
        this.setDiseaseDeaths(scaleFactor * this.getDiseaseDeaths());
        return this;
    }

    public IntegrationLabelValue add(double addition) {
        this.setS(this.getS() + addition);
        this.setDiseaseDeaths(this.getDiseaseDeaths() + addition);
        this.setIncidence(this.getIncidence() + addition);
        return this;
    }

    public IntegrationLabelValue abs() {
        this.setS(Math.abs(this.getS()));
        this.setDiseaseDeaths(Math.abs(this.getDiseaseDeaths()));
        this.setIncidence(Math.abs(this.getIncidence()));
        return this;
    }

    public boolean avoidNegative(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        boolean adjusted = false;
        if (this.getS() + v.getS() < 0.0) {
            this.setS(-v.getS());
            adjusted = true;
        }
        if (this.getIncidence() + v.getIncidence() < 0.0) {
            this.setIncidence(-v.getIncidence());
            adjusted = true;
        }
        if (this.getDiseaseDeaths() + v.getDiseaseDeaths() < 0.0) {
            this.setDiseaseDeaths(-v.getDiseaseDeaths());
            adjusted = true;
        }
        return adjusted;
    }

    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        double factor = 1.0;
        if (this.getS() + v.getS() < 0.0) {
            factor = Math.min(factor, -v.getS() / this.getS());
        }
        if (this.getIncidence() + v.getIncidence() < 0.0) {
            factor = Math.min(factor, -v.getIncidence() / this.getIncidence());
        }
        if (this.getDiseaseDeaths() + v.getDiseaseDeaths() < 0.0) {
            factor = Math.min(factor, -v.getDiseaseDeaths() / this.getDiseaseDeaths());
        }
        return factor;
    }

    public IntegrationLabelValue divide(IntegrationLabelValue value) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)value;
        this.setS(this.getS() / v.getS());
        this.setDiseaseDeaths(this.getDiseaseDeaths() / v.getDiseaseDeaths());
        this.setIncidence(this.getIncidence() / v.getIncidence());
        return this;
    }

    public double max() {
        double max = 0.0;
        max = Math.max(max, this.getS());
        max = Math.max(max, this.getDiseaseDeaths());
        return max;
    }

    @Override
    public void eSetDouble(int featureId, double newValue) {
        switch (featureId) {
            case 3: {
                this.setS(newValue);
                return;
            }
            case 4: {
                this.setIncidence(newValue);
                return;
            }
            case 5: {
                this.setDiseaseDeaths(newValue);
                return;
            }
        }
        super.eSetDouble(featureId, newValue);
    }

    @Override
    public double eGetDouble(int featureId) {
        switch (featureId) {
            case 3: {
                return this.getS();
            }
            case 4: {
                return this.getIncidence();
            }
            case 5: {
                return this.getDiseaseDeaths();
            }
        }
        return super.eGetDouble(featureId);
    }

    public void prepareCycle() {
        this.setIncidence(0.0);
    }

    public void reset() {
        this.setS(0.0);
        this.setIncidence(0.0);
        this.setDiseaseDeaths(0.0);
        while (this.getArrivals().size() > 0) {
            ExchangePool.POOL.release(this.getArrivals().remove(0));
        }
        while (this.getDepartures().size() > 0) {
            ExchangePool.POOL.release(this.getDepartures().remove(0));
        }
    }

    public boolean sameValue(LabelValue otherLabelValue) {
        StandardDiseaseModelLabelValue v = (StandardDiseaseModelLabelValue)otherLabelValue;
        if (this.getS() != v.getS()) {
            return false;
        }
        if (this.getIncidence() != v.getIncidence()) {
            return false;
        }
        return this.getDiseaseDeaths() == v.getDiseaseDeaths();
    }

    @Override
    public double getPopulationCount() {
        return this.getS();
    }
}

