/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.views.DisplayAreaDialog;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEView;
import org.eclipse.stem.ui.ge.views.GEViewContentProvider;
import org.eclipse.stem.ui.ge.views.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class GEViewActions {
    private GEView geView = null;
    private GEInterface gei = null;
    private ListViewer viewer = null;
    private GEViewContentProvider contentProvider = null;
    private Action actionStop;
    private Action actionStart;
    private Action actionMap;
    private Action actionMapNode;
    private Action actionStatus;
    private Action actionGEStart;
    private Action actionGERestart;
    private Action actionGERun;
    private Action actionGEStop;
    private Action actionDebug;
    private final Action doubleClickAction = null;

    public GEViewActions(GEView geView, GEInterface gei) {
        this.geView = geView;
        this.gei = gei;
        this.viewer = geView.getViewer();
        this.contentProvider = geView.getContentProvider();
        this.hookContextMenu();
    }

    private void makeActions() {
        this.actionStop = new Action(){

            public void run() {
                GEViewActions.this.gei.setActive(GEViewActions.this.contentProvider.getCurrentSimulation(), false);
                GEViewActions.this.geView.showMessage(Messages.getString("GEView.4"));
            }
        };
        this.actionStop.setText(Messages.getString("GEView.5"));
        this.actionStop.setToolTipText(Messages.getString("GEView.6"));
        this.actionStop.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionStart = new Action(){

            public void run() {
                String logFolder = GEViewActions.this.geView.verifyFolder(GEPreferencePage.getFolder());
                if (logFolder == null) {
                    return;
                }
                GEPreferencePage.setFolder(logFolder);
                boolean ok = GEViewActions.this.gei.setActive(GEViewActions.this.contentProvider.getCurrentSimulation(), true);
                if (!ok) {
                    GEViewActions.this.geView.showMessage(GEViewActions.this.gei.getErrorMessage());
                } else {
                    GEViewActions.this.geView.showMessage(String.format("GoogleEarth logging ON. To: %s", logFolder));
                }
            }
        };
        this.actionStart.setText(Messages.getString("GEView.7"));
        this.actionStart.setToolTipText(Messages.getString("GEView.8"));
        this.actionStart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGEStart = new Action(){

            public void run() {
                GEViewActions.this.gei.startGE();
            }
        };
        this.actionGEStart.setText(Messages.getString("GEView.9"));
        this.actionGEStart.setToolTipText(Messages.getString("GEView.10"));
        this.actionGEStart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGERestart = new Action(){

            public void run() {
                GEViewActions.this.gei.restartGE();
            }
        };
        this.actionGERestart.setText(Messages.getString("GEView.9a"));
        this.actionGERestart.setToolTipText(Messages.getString("GEView.10a"));
        this.actionGERestart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGERun = new Action(){

            public void run() {
                boolean ok;
                String folder = GEPreferencePage.getFolder();
                if ((folder = GEViewActions.this.geView.displayFolderDialog(folder)) != null && !(ok = GEViewActions.this.gei.runGE(folder))) {
                    GEViewActions.this.geView.showMessage(GEViewActions.this.gei.getErrorMessage());
                }
            }
        };
        this.actionGERun.setText(Messages.getString("GEView.11"));
        this.actionGERun.setToolTipText(Messages.getString("GEView.12"));
        this.actionGERun.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGEStop = new Action(){

            public void run() {
                GEViewActions.this.gei.stopGE();
            }
        };
        this.actionGEStop.setText(Messages.getString("GEView.13"));
        this.actionGEStop.setToolTipText(Messages.getString("GEView.14"));
        this.actionGEStop.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionMap = new Action(){

            public void run() {
                boolean ok = GEViewActions.this.gei.displayMap(GEViewActions.this.contentProvider.getCurrentSimulation());
                if (!ok) {
                    GEViewActions.this.geView.showMessage(Messages.getString("GEView.15"));
                }
            }
        };
        this.actionMap.setText(Messages.getString("GEView.16"));
        this.actionMap.setToolTipText(Messages.getString("GEView.17"));
        this.actionMap.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionMapNode = new Action(){

            public void run() {
                String area = null;
                String adminFile = null;
                String search = null;
                DisplayAreaDialog input = new DisplayAreaDialog(Display.getCurrent().getActiveShell());
                boolean done = false;
                while (!done) {
                    int rc = input.open();
                    if (rc == 0 || rc == 10) {
                        adminFile = input.getAdminFile();
                        search = input.getSearch().trim();
                        boolean clear = input.isClear();
                        Aspect a = GEViewActions.this.gei.getAspectToDisplay(GEViewActions.this.contentProvider.getCurrentSimulation());
                        GELog.debug((Object)this, "Display: " + area + " aspect: " + a.toString());
                        boolean ok = GEViewActions.this.gei.displayArea(adminFile, search, clear);
                        if (!ok) {
                            GEViewActions.this.geView.showMessage(String.valueOf(Messages.getString("GEView.15n")) + "\n" + GEViewActions.this.gei.getErrorMessage());
                            continue;
                        }
                        if (rc != 0) continue;
                        done = true;
                        continue;
                    }
                    if (rc != 1) continue;
                    done = true;
                }
            }
        };
        this.actionMapNode.setText(Messages.getString("GEView.16n"));
        this.actionMapNode.setToolTipText(Messages.getString("GEView.17n"));
        this.actionMapNode.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionStatus = new Action(){

            public void run() {
                boolean save = GELog.DEBUG;
                GELog.DEBUG = true;
                GEViewActions.this.gei.displayStatus();
                GELog.DEBUG = save;
            }
        };
        this.actionStatus.setText(Messages.getString("GEView.18"));
        this.actionStatus.setToolTipText(Messages.getString("GEView.19"));
        this.actionStatus.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionDebug = new Action(){

            public void run() {
                if (GELog.DEBUG) {
                    GELog.debug((Object)this, "Turning DEBUG off");
                    GELog.DEBUG = false;
                } else {
                    GELog.DEBUG = true;
                    GELog.debug((Object)this, "Turned DEBUG on");
                }
            }
        };
        if (GELog.DEBUG) {
            this.actionDebug.setText(Messages.getString("GEView.20Off"));
        } else {
            this.actionDebug.setText(Messages.getString("GEView.20On"));
        }
        this.actionDebug.setToolTipText(Messages.getString("GEView.21"));
        this.actionDebug.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("GoogleEarth");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GEViewActions.this.makeActions();
                GEViewActions.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.viewer.getControl().setMenu(menu);
        this.geView.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        ISimulation sim = this.contentProvider.getCurrentSimulation();
        if (sim != null) {
            if (this.gei.isActive(sim)) {
                this.actionStop.setEnabled(true);
                manager.add((IAction)this.actionStop);
                this.actionStart.setEnabled(false);
                manager.add((IAction)this.actionStart);
            } else {
                this.actionStop.setEnabled(false);
                manager.add((IAction)this.actionStop);
                this.actionStart.setEnabled(true);
                manager.add((IAction)this.actionStart);
            }
            manager.add((IAction)this.actionMap);
        }
        manager.add((IAction)this.actionMapNode);
        manager.add((IAction)this.actionStatus);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDebug);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionGEStart);
        manager.add((IAction)this.actionGERestart);
        manager.add((IAction)this.actionGERun);
        manager.add((IAction)this.actionGEStop);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GEViewActions.this.doubleClickAction.run();
            }
        });
    }
}

