/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;

public class MethodCall {
    private IMember fMember;
    private List<CallLocation> fCallLocations;

    public MethodCall(IMember enclosingElement) {
        this.fMember = enclosingElement;
    }

    public Collection<CallLocation> getCallLocations() {
        return this.fCallLocations;
    }

    public CallLocation getFirstCallLocation() {
        if (this.fCallLocations != null && !this.fCallLocations.isEmpty()) {
            return this.fCallLocations.get(0);
        }
        return null;
    }

    public boolean hasCallLocations() {
        return this.fCallLocations != null && this.fCallLocations.size() > 0;
    }

    public String getKey() {
        return this.getMember().getHandleIdentifier();
    }

    public IMember getMember() {
        return this.fMember;
    }

    public void addCallLocation(CallLocation location) {
        if (this.fCallLocations == null) {
            this.fCallLocations = new ArrayList<CallLocation>();
        }
        this.fCallLocations.add(location);
    }
}

