/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.veterinary.presentation;

import java.util.MissingResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.diseasemodels.veterinary.ContaminatedUnits;
import org.eclipse.stem.diseasemodels.veterinary.VeterinaryPackage;
import org.eclipse.stem.diseasemodels.veterinary.presentation.VeterinaryWizardMessages;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditor;
import org.eclipse.stem.ui.populationmodels.standard.wizards.StandardPropertyStringProviderAdapterFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ContaminatedUnitsPropertyEditor
extends PopulationModelPropertyEditor {
    public ContaminatedUnitsPropertyEditor(Composite parent, int style, PopulationModel model, ModifyListener projectValidator, IProject project) {
        super(parent, style, model, projectValidator, project);
    }

    public void populate(PopulationModel object) {
        super.populate(object);
        ContaminatedUnits model = (ContaminatedUnits)object;
        try {
            Double dissapationRateValue = Double.parseDouble(((Text)this.map.get(VeterinaryPackage.Literals.CONTAMINATED_UNITS__DISSAPATION_RATE)).getText());
            model.setDissapationRate(dissapationRateValue);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            Double sheddingFactorValue = Double.parseDouble(((Text)this.map.get(VeterinaryPackage.Literals.CONTAMINATED_UNITS__SHEDDING_FACTOR)).getText());
            model.setSheddingFactor(sheddingFactorValue);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public boolean validate() {
        boolean valid = super.validate();
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VeterinaryPackage.Literals.CONTAMINATED_UNITS__DISSAPATION_RATE);
        valid = valid && this.validateFeatureConstraint((EStructuralFeature)VeterinaryPackage.Literals.CONTAMINATED_UNITS__SHEDDING_FACTOR);
        return valid;
    }

    public static class ContaminatedUnitsPropertyStringProviderAdapter
    extends StandardPropertyStringProviderAdapterFactory.StandardPropertyStringProviderAdapter {
        public String getPropertyName(IItemPropertyDescriptor descriptor) {
            try {
                return VeterinaryWizardMessages.getString(((EStructuralFeature)descriptor.getFeature(null)).getName(), "ContaminatedUnits");
            }
            catch (MissingResourceException missingResourceException) {
                return super.getPropertyName(descriptor);
            }
        }

        public String getPropertyToolTip(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VeterinaryWizardMessages.getString(String.valueOf(feature.getName()) + "TT", "ContaminatedUnits");
            }
            catch (MissingResourceException missingResourceException) {
                return super.getPropertyToolTip(descriptor);
            }
        }

        public String getPropertyUnits(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VeterinaryWizardMessages.getString(String.valueOf(feature.getName()) + "UNIT", "ContaminatedUnits");
            }
            catch (MissingResourceException missingResourceException) {
                return super.getPropertyUnits(descriptor);
            }
        }

        public String getPropertyMissing(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VeterinaryWizardMessages.getString(String.valueOf(feature.getName()) + "MISSING", "ContaminatedUnits");
            }
            catch (MissingResourceException missingResourceException) {
                return super.getPropertyMissing(descriptor);
            }
        }

        public String getPropertyInvalid(IItemPropertyDescriptor descriptor) {
            try {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                return VeterinaryWizardMessages.getString(String.valueOf(feature.getName()) + "INVALID", "ContaminatedUnits");
            }
            catch (MissingResourceException missingResourceException) {
                return super.getPropertyInvalid(descriptor);
            }
        }
    }
}

