/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.evolving.impl;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.TransformationDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.diseasemodels.evolving.EvolvingDiseaseModel;
import org.eclipse.stem.diseasemodels.evolving.EvolvingDiseaseTransformer;
import org.eclipse.stem.diseasemodels.evolving.EvolvingPackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;

public class EvolvingDiseaseTransformerImpl
extends TransformationDecoratorImpl
implements EvolvingDiseaseTransformer {
    protected DiseaseModel baseDisease;
    protected EList<DiseaseModel> evolvedDiseases;
    protected static final int EVOLUTION_COUNT_EDEFAULT = 0;
    protected int evolutionCount = 0;
    protected static final int EVOLUTION_COUNT_HARD_LIMIT_EDEFAULT = 255;
    protected int evolutionCountHardLimit = 255;
    protected static final boolean STOP_ALL_EVOLUTION_EDEFAULT = false;
    protected boolean stopAllEvolution = false;

    public EvolvingDiseaseTransformerImpl() {
        this.setURI(STEMURI.createURI((String)("/" + STEMURI.generateUniquePart() + "/EvolvingDiseaseTransformerImpl")));
        this.setTypeURI(URI_TYPE_TRANSFORMER);
    }

    protected EClass eStaticClass() {
        return EvolvingPackage.Literals.EVOLVING_DISEASE_TRANSFORMER;
    }

    @Override
    public DiseaseModel getBaseDisease() {
        if (this.baseDisease != null && this.baseDisease.eIsProxy()) {
            InternalEObject oldBaseDisease = (InternalEObject)this.baseDisease;
            this.baseDisease = (DiseaseModel)this.eResolveProxy(oldBaseDisease);
        }
        return this.baseDisease;
    }

    public DiseaseModel basicGetBaseDisease() {
        return this.baseDisease;
    }

    @Override
    public void setBaseDisease(DiseaseModel newBaseDisease) {
        this.baseDisease = newBaseDisease;
    }

    @Override
    public EList<DiseaseModel> getEvolvedDiseases() {
        if (this.evolvedDiseases == null) {
            this.evolvedDiseases = new BasicInternalEList(DiseaseModel.class);
        }
        return this.evolvedDiseases;
    }

    @Override
    public int getEvolutionCount() {
        return this.evolutionCount;
    }

    @Override
    public void setEvolutionCount(int newEvolutionCount) {
        this.evolutionCount = newEvolutionCount;
    }

    @Override
    public int getEvolutionCountHardLimit() {
        return this.evolutionCountHardLimit;
    }

    @Override
    public void setEvolutionCountHardLimit(int newEvolutionCountHardLimit) {
        this.evolutionCountHardLimit = newEvolutionCountHardLimit;
    }

    @Override
    public boolean isStopAllEvolution() {
        return this.stopAllEvolution;
    }

    @Override
    public void setStopAllEvolution(boolean newStopAllEvolution) {
        this.stopAllEvolution = newStopAllEvolution;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getBaseDisease();
                }
                return this.basicGetBaseDisease();
            }
            case 10: {
                return this.getEvolvedDiseases();
            }
            case 11: {
                return this.getEvolutionCount();
            }
            case 12: {
                return this.getEvolutionCountHardLimit();
            }
            case 13: {
                return this.isStopAllEvolution();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setBaseDisease((DiseaseModel)newValue);
                return;
            }
            case 10: {
                this.getEvolvedDiseases().clear();
                this.getEvolvedDiseases().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setEvolutionCount((Integer)newValue);
                return;
            }
            case 12: {
                this.setEvolutionCountHardLimit((Integer)newValue);
                return;
            }
            case 13: {
                this.setStopAllEvolution((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setBaseDisease(null);
                return;
            }
            case 10: {
                this.getEvolvedDiseases().clear();
                return;
            }
            case 11: {
                this.setEvolutionCount(0);
                return;
            }
            case 12: {
                this.setEvolutionCountHardLimit(255);
                return;
            }
            case 13: {
                this.setStopAllEvolution(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.baseDisease != null;
            }
            case 10: {
                return this.evolvedDiseases != null && !this.evolvedDiseases.isEmpty();
            }
            case 11: {
                return this.evolutionCount != 0;
            }
            case 12: {
                return this.evolutionCountHardLimit != 255;
            }
            case 13: {
                return this.stopAllEvolution;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (evolutionCount: ");
        result.append(this.evolutionCount);
        result.append(", evolutionCountHardLimit: ");
        result.append(this.evolutionCountHardLimit);
        result.append(", stopAllEvolution: ");
        result.append(this.stopAllEvolution);
        result.append(')');
        return result.toString();
    }

    public void updateLabels(STEMTime time, long timerPeriod, int cycle) {
        if (this.stopAllEvolution) {
            return;
        }
        HashSet exisitingNodeKeys = new HashSet(this.getGraph().getNodeLabels().keySet());
        for (URI nodeUri : exisitingNodeKeys) {
            EvolvingDiseaseModel baseDiseaseModel;
            EvolvingDiseaseModel evolvedDiseaseModel;
            DiseaseModelLabel dmLabel;
            NodeLabel nodeLabel = (NodeLabel)this.getGraph().getNodeLabels().get((Object)nodeUri);
            if (!(nodeLabel instanceof DiseaseModelLabel) || !((dmLabel = (DiseaseModelLabel)nodeLabel).getDecorator() instanceof EvolvingDiseaseModel) || (evolvedDiseaseModel = (baseDiseaseModel = (EvolvingDiseaseModel)dmLabel.getDecorator()).evolve(dmLabel)) == null) continue;
            ++this.evolutionCount;
            if (this.evolutionCount >= this.evolutionCountHardLimit) {
                System.out.println("Evolution Count Exceeds hard limit");
                this.stopAllEvolution = true;
            }
            try {
                DiseaseModel evolvedDiseaseAsModel = (DiseaseModel)evolvedDiseaseModel;
                this.getEvolvedDiseases().add((Object)evolvedDiseaseAsModel);
                this.getGraph().getDecorators().add((Object)evolvedDiseaseAsModel);
                evolvedDiseaseAsModel.decorateGraph(time);
                evolvedDiseaseAsModel.setGraphDecorated(true);
                evolvedDiseaseModel.calculateEvolvedInitialState();
                System.err.println("*** Mutation ***" + this.evolutionCount);
            }
            catch (ScenarioInitializationException scenarioInitializationException) {
                System.err.println("Error decorating mutated disease model");
            }
        }
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
    }

    public void resetLabels() throws ScenarioInitializationException {
        super.resetLabels();
        this.evolutionCount = 0;
        this.getEvolvedDiseases().clear();
    }
}

