/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.commands.emf;

import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.stem.model.ui.editor.commands.emf.EmfCommandWrapper;

public class DelegatingCommandStack
implements org.eclipse.emf.common.command.CommandStack,
CommandStackEventListener {
    private CommandStack gefStack;
    private List<CommandStackListener> listeners = new CopyOnWriteArrayList<CommandStackListener>();

    public DelegatingCommandStack(CommandStack gefStack) {
        this.gefStack = gefStack;
        gefStack.addCommandStackEventListener((CommandStackEventListener)this);
    }

    public void execute(Command command) {
        this.gefStack.execute((org.eclipse.gef.commands.Command)new EmfCommandWrapper(command));
    }

    public boolean canUndo() {
        return this.gefStack.canUndo();
    }

    public void undo() {
        this.gefStack.undo();
    }

    public boolean canRedo() {
        return this.gefStack.canRedo();
    }

    public Command getUndoCommand() {
        org.eclipse.gef.commands.Command gefCommand = this.gefStack.getUndoCommand();
        if (gefCommand instanceof EmfCommandWrapper) {
            return ((EmfCommandWrapper)gefCommand).getOriginalCommand();
        }
        return null;
    }

    public Command getRedoCommand() {
        org.eclipse.gef.commands.Command gefCommand = this.gefStack.getRedoCommand();
        if (gefCommand instanceof EmfCommandWrapper) {
            return ((EmfCommandWrapper)gefCommand).getOriginalCommand();
        }
        return null;
    }

    public Command getMostRecentCommand() {
        if (this.gefStack.getCommands().length > 0 && this.gefStack.getCommands()[0] instanceof EmfCommandWrapper) {
            return ((EmfCommandWrapper)((Object)this.gefStack.getCommands()[0])).getOriginalCommand();
        }
        return null;
    }

    public void redo() {
        this.gefStack.redo();
    }

    public void flush() {
        this.gefStack.flush();
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void stackChanged(CommandStackEvent event) {
        EventObject wrappedEventObject = new EventObject(this);
        for (CommandStackListener listener : this.listeners) {
            listener.commandStackChanged(wrappedEventObject);
        }
    }
}

