/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.ModelGenerator;
import org.eclipse.stem.model.ui.editor.ModelDiagramEditor;
import org.eclipse.stem.model.ui.editor.vismodel.provider.VisualMetamodelEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RunModelGeneratorAction
extends Action {
    protected ModelDiagramEditor editor;
    protected Package metamodel;
    protected boolean forceConfirm = false;
    protected boolean saveConfirm = false;

    public RunModelGeneratorAction(ModelDiagramEditor editor) {
        this.editor = editor;
        this.metamodel = editor.getMetamodel();
    }

    private Shell getShell() {
        return this.editor.getSite().getShell();
    }

    private boolean confirmForceRegen() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RunModelGeneratorAction.this.forceConfirm = MessageDialog.openConfirm((Shell)RunModelGeneratorAction.this.getShell(), (String)"Regeneration not required", (String)"The project does not need regeneration.  Run generator anyway?");
            }
        });
        return this.forceConfirm;
    }

    private boolean confirmSave() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RunModelGeneratorAction.this.saveConfirm = MessageDialog.openConfirm((Shell)RunModelGeneratorAction.this.getShell(), (String)"Save Model", (String)"You must save the metamodel before running the model generator.  Save and continue?");
            }
        });
        return this.saveConfirm;
    }

    private void openMetamodelErrorDialog() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)RunModelGeneratorAction.this.getShell(), (String)"Error", (String)"No metamodel available to generate");
            }
        });
    }

    private void runValidateMetamodel(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validating Metamodel", (int)10);
        if (this.editor.isDirty() && !this.confirmSave()) {
            subMonitor.setCanceled(true);
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        if (this.editor.getMetamodel() == null) {
            this.openMetamodelErrorDialog();
            subMonitor.setCanceled(true);
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        try {
            if (!this.editor.needsModelRegeneration((IProgressMonitor)subMonitor.split(10)) && !this.confirmForceRegen()) {
                subMonitor.setCanceled(true);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (subMonitor.isCanceled()) {
            return;
        }
    }

    private void runModelGenerator(IProgressMonitor monitor) throws CoreException, IOException {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Running Model Generator", (int)10);
        if (this.editor.isDirty()) {
            subMonitor.subTask("Saving metamodel");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    RunModelGeneratorAction.this.editor.doSave((IProgressMonitor)subMonitor.split(1));
                }
            });
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        ModelGenerator.run((Package)this.metamodel, (IProgressMonitor)subMonitor.split(1));
    }

    public void run() {
        try {
            ProgressMonitorDialog pmdialog = new ProgressMonitorDialog(this.getShell());
            pmdialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Model Generator", (int)10);
                    try {
                        RunModelGeneratorAction.this.runValidateMetamodel((IProgressMonitor)subMonitor.split(1));
                        if (monitor.isCanceled()) {
                            return;
                        }
                        RunModelGeneratorAction.this.runModelGenerator((IProgressMonitor)subMonitor.split(9));
                    }
                    catch (Throwable t) {
                        RunModelGeneratorAction.this.handleThrowable(t);
                    }
                }
            });
            if (!pmdialog.getProgressMonitor().isCanceled()) {
                this.editor.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleThrowable(Throwable t) {
        Status status = new Status(4, "org.eclipse.stem.model.ui.editor", t.getMessage(), t);
        VisualMetamodelEditPlugin.log((IStatus)status);
        ErrorDialog.openError((Shell)this.getShell(), (String)"Model Regeneration Error", null, (IStatus)status);
    }
}

