/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.text.NumberFormatter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.views.geographic.GeographicControl;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class GeographicRenderer
extends Composite
implements ISelectionProvider {
    protected static final float INITIAL_GAIN_FACTOR = 1.0f;
    protected static final boolean INITIAL_DRAW_POLYGON_BORDERS = true;
    protected static final boolean INITIAL_USE_LOG_SCALING = true;
    protected static final int MARGIN_HEIGHT = 5;
    protected static final int MARGIN_WIDTH = 5;
    private static NumberFormatter formatter = new NumberFormatter();
    protected boolean drawPolygonBorders = true;
    protected Stroke polygonStroke = new BasicStroke(1.0f);
    protected boolean useLogScaling = true;
    protected float gainFactor = 1.0f;
    private GainFactorAction defaultGainFactorAction;
    GainFactorAction lastGainFactorAction;
    private LogarithmicAction logarithmicAction;
    private DrawPolygonBordersAction drawPolygonBordersAction;
    protected ColorProviderAdapter colorProviderAdapter = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private ISelection selection;
    protected Label gainScaleLabel;
    protected NumberFormat gainFormatter = new DecimalFormat("#0.000");

    public GeographicRenderer(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!GeographicRenderer.this.isDisposed()) {
                    GeographicRenderer.this.dispose();
                }
            }
        });
    }

    public abstract void render(StemPolygonsList var1, ISimulation var2);

    protected Color getColorForRelativeValue(double relativeValue) {
        return null;
    }

    public void dispose() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    public void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void reset() {
        this.lastGainFactorAction.setChecked(false);
        this.defaultGainFactorAction.run();
        this.defaultGainFactorAction.setChecked(true);
        this.useLogScaling = true;
        this.logarithmicAction.setChecked(this.useLogScaling);
        this.drawPolygonBorders = true;
        this.drawPolygonBordersAction.setChecked(this.drawPolygonBorders);
    }

    public void updateScaleLogLinLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.useLogScaling) {
            sb.append(Messages.getString("MapMenu.LogScale"));
        } else {
            sb.append(Messages.getString("MapMenu.LinScale"));
        }
        sb.append("  ");
        sb.append(Messages.getString("MapMenu.Gain"));
        sb.append(" x");
        sb.append(this.gainFormatter.format(this.gainFactor));
        this.gainScaleLabel.setText(sb.toString());
    }

    protected void setGainFactor(float gainFactor) {
        this.gainFactor = gainFactor;
        this.updateScaleLogLinLabel();
    }

    protected void toggleDrawPolygonBordersChoice() {
        this.drawPolygonBorders = !this.drawPolygonBorders;
        this.redraw();
    }

    protected void toggleUseLogScaling() {
        this.useLogScaling = !this.useLogScaling;
        this.updateScaleLogLinLabel();
        this.redraw();
    }

    public MenuManager createContextMenuManager() {
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IContributionItem)this.createGainFactorMenu());
        this.logarithmicAction = new LogarithmicAction();
        contextMenuManager.add((IAction)this.logarithmicAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this.drawPolygonBordersAction = new DrawPolygonBordersAction();
        contextMenuManager.add((IAction)this.drawPolygonBordersAction);
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IContributionItem)new Separator());
        contextMenuManager.add((IAction)new ResetMapCanvasAction());
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        return contextMenuManager;
    }

    private MenuManager createGainFactorMenu() {
        MenuManager gainFactorMenu = new MenuManager(Messages.getString("MapMenu.GainFactor"));
        gainFactorMenu.add((IAction)new GainFactorAction(0.001));
        gainFactorMenu.add((IAction)new GainFactorAction(0.01));
        gainFactorMenu.add((IAction)new GainFactorAction(0.1));
        this.lastGainFactorAction = this.defaultGainFactorAction = new GainFactorAction(1.0);
        gainFactorMenu.add((IAction)this.defaultGainFactorAction);
        gainFactorMenu.add((IAction)new GainFactorAction(10.0));
        gainFactorMenu.add((IAction)new GainFactorAction(100.0));
        gainFactorMenu.add((IAction)new GainFactorAction(1000.0));
        gainFactorMenu.add((IAction)new GainFactorAction(10000.0));
        gainFactorMenu.add((IAction)new GainFactorAction(100000.0));
        gainFactorMenu.add((IAction)new GainFactorAction(1000000.0));
        gainFactorMenu.add((IAction)new GainFactorAction(1.0E7));
        return gainFactorMenu;
    }

    private MenuManager createReportsSelectionMenu() {
        MenuManager reportsSelectionMenu = new MenuManager(Messages.getString("MapMenu.Reports_Select"), "reports");
        reportsSelectionMenu.add((IContributionItem)new Separator("additions"));
        return reportsSelectionMenu;
    }

    String getText(double factor) {
        String retValue = "";
        try {
            retValue = formatter.valueToString(factor);
        }
        catch (ParseException e) {
            Activator.logError("Problem parsing gain factor value \"" + factor + "\"", e);
        }
        return retValue;
    }

    public void setColorProviderAdapter(ColorProviderAdapter colorProvider) {
        this.colorProviderAdapter = colorProvider;
    }

    protected class DrawPolygonBordersAction
    extends Action {
        public DrawPolygonBordersAction() {
            super(Messages.getString("MapMenu.Polygon_Borders"), 2);
            if (GeographicRenderer.this.drawPolygonBorders) {
                this.setChecked(true);
            }
        }

        public String getText() {
            return Messages.getString("MapMenu.Polygon_Borders");
        }

        public void run() {
            GeographicRenderer.this.toggleDrawPolygonBordersChoice();
            Composite parent = GeographicRenderer.this.getParent();
            ((GeographicControl)parent).refresh();
        }
    }

    protected class GainFactorAction
    extends Action {
        private final double factor;

        GainFactorAction(double factor) {
            super(GeographicRenderer.this.getText(factor), 8);
            this.factor = factor;
            this.setChecked(factor == 1.0);
        }

        public String getText() {
            return GeographicRenderer.this.getText(this.factor);
        }

        public void run() {
            GeographicRenderer.this.setGainFactor((float)this.factor);
            GeographicRenderer.this.lastGainFactorAction = this;
            Composite parent = GeographicRenderer.this.getParent();
            ((GeographicControl)parent).refresh();
        }
    }

    protected class LogarithmicAction
    extends Action {
        public LogarithmicAction() {
            super(Messages.getString("MapMenu.Logrithmic_Scaling"), 2);
            this.setChecked(GeographicRenderer.this.useLogScaling);
        }

        public String getText() {
            return Messages.getString("MapMenu.Logrithmic_Scaling");
        }

        public void run() {
            GeographicRenderer.this.toggleUseLogScaling();
            Composite parent = GeographicRenderer.this.getParent();
            ((GeographicControl)parent).refresh();
        }
    }

    protected class ResetMapCanvasAction
    extends Action {
        protected ResetMapCanvasAction() {
        }

        public String getText() {
            return Messages.getString("MapMenu.Reset");
        }

        public void run() {
            GeographicRenderer.this.reset();
        }
    }
}

