/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stem.ui.Activator;
import org.osgi.framework.Bundle;

public class NLS {
    private static final String PROPERTY_COMMENT_MESSAGE = "Edited by STEM NLS Switcher";
    private static final String NULL_PROPERTY_FILE_MESSAGE = "Cannot determine path for OSGi configuration file.  Verify the osgi.configuration.area system property is set.";
    public static final String DEFAULT_LOCALE = "en";
    public static final String SYSTEM_LOCALE_PROPERTY = "stem.system.nl";
    public static final String OSGI_RUNTIME_LOCALE_PROPERTY = "osgi.nl";
    public static final String OSGI_RUNTIME_CONFIG_PATH_PROPERTY = "osgi.configuration.area";
    public static final String OSGI_RUNTIME_CONFIG_FILE_NAME = "config.ini";
    private static String CURRENT_LOCALE = null;
    private static String SYSTEM_LOCALE = null;
    private static Collection<String> AVAILABLE_LOCALES = null;

    private NLS() {
    }

    public static String getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    private static List<String> getLocaleFragments(String locale) {
        String[] localeFragments = locale.split("_");
        ArrayList<String> possibleLocales = new ArrayList<String>();
        StringBuilder fragment = new StringBuilder();
        fragment.append(localeFragments[0]);
        possibleLocales.add(fragment.toString());
        if (localeFragments.length > 1) {
            int i = 1;
            while (i < localeFragments.length) {
                fragment.append("_");
                fragment.append(localeFragments[i]);
                possibleLocales.add(fragment.toString());
                ++i;
            }
        }
        Collections.reverse(possibleLocales);
        return possibleLocales;
    }

    public static String getCurrentLocale() {
        if (CURRENT_LOCALE == null) {
            String platformLocale = Platform.getNL();
            List<String> fragments = NLS.getLocaleFragments(platformLocale);
            Collection<String> locales = NLS.getAvailableLocales();
            for (String fragment : fragments) {
                if (!locales.contains(fragment)) continue;
                CURRENT_LOCALE = fragment;
                break;
            }
            if (CURRENT_LOCALE == null) {
                CURRENT_LOCALE = NLS.getDefaultLocale();
            }
        }
        return CURRENT_LOCALE;
    }

    public static String getSystemLocale() {
        if (SYSTEM_LOCALE == null) {
            String systemLocale = System.getProperty(SYSTEM_LOCALE_PROPERTY);
            if (systemLocale == null) {
                systemLocale = Platform.getNL();
            }
            if (systemLocale != null) {
                List<String> fragments = NLS.getLocaleFragments(systemLocale);
                Collection<String> locales = NLS.getAvailableLocales();
                for (String fragment : fragments) {
                    if (!locales.contains(fragment)) continue;
                    SYSTEM_LOCALE = fragment;
                    break;
                }
            }
            if (SYSTEM_LOCALE == null) {
                SYSTEM_LOCALE = NLS.getDefaultLocale();
            }
        }
        return SYSTEM_LOCALE;
    }

    public static synchronized Collection<String> getAvailableLocales() {
        if (AVAILABLE_LOCALES == null) {
            ArrayList<String> locales = new ArrayList<String>();
            Enumeration paths = Activator.getDefault().getBundle().findEntries("/", "plugin*.properties", false);
            locales.add(DEFAULT_LOCALE);
            while (paths.hasMoreElements()) {
                String locale;
                String url = ((URL)paths.nextElement()).toString();
                int firstPart = url.indexOf(95);
                int lastPart = url.lastIndexOf(".properties");
                if (firstPart == -1 || lastPart == -1 || locales.contains(locale = url.substring(firstPart + 1, lastPart))) continue;
                locales.add(locale);
            }
            Collections.sort(locales);
            AVAILABLE_LOCALES = Collections.unmodifiableCollection(locales);
        }
        return AVAILABLE_LOCALES;
    }

    public static String getLocaleDisplayName(String locale) {
        String resourceKeyName = "locale_" + locale;
        ResourceBundle rb = Platform.getResourceBundle((Bundle)Activator.getDefault().getBundle());
        String displayName = null;
        try {
            displayName = rb.getString(resourceKeyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (displayName == null || "".equals(displayName)) {
            displayName = locale;
        }
        if (resourceKeyName.equals(displayName)) {
            displayName = locale;
        }
        return displayName;
    }

    public static boolean isCurrentLocale(String locale) {
        return locale.equals(NLS.getCurrentLocale());
    }

    public static boolean isDefaultLocale(String locale) {
        return locale.equals(NLS.getSystemLocale());
    }

    public static void persistNewLocale(String newLocale) throws IOException {
        Reader reader = null;
        Writer writer = null;
        try {
            File configPropertiesFile = NLS.getConfigurationPropertyFile();
            if (configPropertiesFile == null) {
                throw new FileNotFoundException(NULL_PROPERTY_FILE_MESSAGE);
            }
            Properties configProps = new Properties();
            reader = new FileReader(configPropertiesFile);
            configProps.load(reader);
            configProps.put(SYSTEM_LOCALE_PROPERTY, NLS.getSystemLocale());
            configProps.put(OSGI_RUNTIME_LOCALE_PROPERTY, newLocale);
            writer = new FileWriter(configPropertiesFile);
            configProps.store(writer, PROPERTY_COMMENT_MESSAGE);
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static File getConfigurationPropertyFile() {
        String path = System.getProperty(OSGI_RUNTIME_CONFIG_PATH_PROPERTY);
        if (path == null) {
            return null;
        }
        return new File(path.replace("file:", ""), OSGI_RUNTIME_CONFIG_FILE_NAME);
    }
}

