/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.graphgenerators.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.graphgenerators.GraphGenerator;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor.GraphGeneratorPropertyEditor;
import org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor.GraphGeneratorPropertyEditorAdapter;
import org.eclipse.stem.ui.graphgenerators.adapters.graphgeneratorpropertyeditor.GraphGeneratorPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.graphgenerators.wizards.Messages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GraphGeneratorPropertyComposite
extends Composite {
    private Map<GraphGenerator, GraphGeneratorPropertyEditor> modelMap = new HashMap<GraphGenerator, GraphGeneratorPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public GraphGeneratorPropertyComposite(Composite parent, int style, GraphGenerator[] graphGenerators, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("GGPC1"));
        GraphGeneratorPropertyEditor firstOne = null;
        if (graphGenerators != null) {
            int i = 0;
            while (i < graphGenerators.length) {
                GraphGeneratorPropertyEditorAdapter dmpea = (GraphGeneratorPropertyEditorAdapter)GraphGeneratorPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)graphGenerators[i], GraphGeneratorPropertyEditorAdapter.class);
                GraphGeneratorPropertyEditor dmpe = dmpea.createGraphGeneratorPropertyEditor(this, 0, projectValidator, project);
                this.modelMap.put(graphGenerators[i], dmpe);
                if (firstOne == null) {
                    firstOne = dmpe;
                }
                ++i;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    void displayGraphGenerator(GraphGenerator graphGenerator) {
        GraphGeneratorPropertyEditor dmpe = this.modelMap.get(graphGenerator);
        if (dmpe != null) {
            this.stackLayout.topControl = dmpe;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(Messages.getString("GGPC2")) + graphGenerator.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((GraphGeneratorPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((GraphGeneratorPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public Graph getGraph(GraphGenerator gg) {
        return ((GraphGeneratorPropertyEditor)this.stackLayout.topControl).getGraph(gg);
    }
}

