/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.ModelGenerator;

public class MetamodelRegenerateValidator {
    private Package metamodel;
    private IFile metamodelFile;

    public MetamodelRegenerateValidator(Package metamodel, IFile metamodelFile) {
        this.metamodel = metamodel;
        this.metamodelFile = metamodelFile;
    }

    private static URI getUriForPath(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    private static void safeClose(Reader r) {
        if (r == null) {
            return;
        }
        try {
            r.close();
        }
        catch (Throwable throwable) {}
    }

    private String getGenModelFileAsString(IProgressMonitor monitor) throws CoreException, IOException {
        String string;
        IFile genModelFile;
        BufferedReader reader;
        block4: {
            monitor.beginTask("Reading models", 1);
            reader = null;
            genModelFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.metamodelFile.getLocation().removeFileExtension().addFileExtension("genmodel"));
            if (genModelFile != null) break block4;
            MetamodelRegenerateValidator.safeClose(reader);
            monitor.done();
            return "";
        }
        try {
            reader = new BufferedReader(new InputStreamReader(genModelFile.getContents()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            monitor.worked(1);
            string = builder.toString();
        }
        catch (Throwable throwable) {
            MetamodelRegenerateValidator.safeClose(reader);
            monitor.done();
            throw throwable;
        }
        MetamodelRegenerateValidator.safeClose(reader);
        monitor.done();
        return string;
    }

    private String getGenModelAsString(IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Serializing models", (int)100);
        URI genModelUri = MetamodelRegenerateValidator.getUriForPath(this.getGenModelPath());
        URI ecoreUri = MetamodelRegenerateValidator.getUriForPath(this.getEcorePath());
        ModelGenerator generator = new ModelGenerator(this.metamodel);
        generator.generateEcoreAndGenmodel((IProgressMonitor)subMonitor.split(70));
        GenModel genModel = generator.getGenModel();
        EPackage ecore = generator.getEcore();
        subMonitor.subTask("Creating Ecore Resource");
        ResourceSet rs = generator.getResourceSet();
        Resource ecoreResource = rs.createResource(ecoreUri);
        ecoreResource.getContents().add((Object)ecore);
        subMonitor.worked(10);
        subMonitor.subTask("Creating GenModel Resource");
        Resource genModelResource = rs.createResource(genModelUri);
        genModelResource.getContents().add((Object)genModel);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        genModelResource.save((OutputStream)baos, null);
        subMonitor.worked(20);
        genModelResource.unload();
        ecoreResource.unload();
        return baos.toString();
    }

    private IPath getMetamodelPath() {
        return this.metamodelFile.getFullPath();
    }

    private IPath getGenModelPath() {
        return this.getMetamodelPath().removeFileExtension().addFileExtension("genmodel");
    }

    private IPath getEcorePath() {
        return this.getMetamodelPath().removeFileExtension().addFileExtension("ecore");
    }

    public boolean checkNeedRegeneration(IProgressMonitor monitor) throws IOException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Comparing Model Generator output", (int)50);
        String currentGenModel = this.getGenModelFileAsString((IProgressMonitor)subMonitor.split(10));
        String newGenModel = this.getGenModelAsString((IProgressMonitor)subMonitor.split(40));
        return (currentGenModel = currentGenModel.replaceAll("\\s", "")).compareTo(newGenModel = newGenModel.replaceAll("\\s", "")) != 0;
    }
}

