/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor.handlers;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.grapheditor.GraphEditorMessages;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SaveInProjectDialog
extends TitleAreaDialog {
    private IPath result;
    private Text resourceNameField;
    private Button okButton;
    private Combo projectCombo;

    public SaveInProjectDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(GraphEditorMessages.getString("saveAs"));
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(GraphEditorMessages.getString("saveAs"));
        this.setMessage(GraphEditorMessages.getString("saveToLocation"));
        this.okButton.setEnabled(false);
        this.resourceNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SaveInProjectDialog.this.resourceNameField.getText().isEmpty()) {
                    SaveInProjectDialog.this.okButton.setEnabled(false);
                } else {
                    SaveInProjectDialog.this.okButton.setEnabled(true);
                }
            }
        });
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        GridData data = new GridData(768);
        data.widthHint = 250;
        Label selectProject = new Label(composite, 0);
        selectProject.setText(GraphEditorMessages.getString("selectProject"));
        this.projectCombo = new Combo(composite, 8);
        this.initializeProjectCombo(this.projectCombo);
        this.projectCombo.setLayoutData((Object)data);
        new Label(composite, 0);
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(GraphEditorMessages.getString("nameOfGraphFile"));
        this.resourceNameField = new Text(composite, 2048);
        this.resourceNameField.setLayoutData((Object)data);
        return parentComposite;
    }

    public IPath getResult() {
        return this.result;
    }

    protected void okPressed() {
        IFile file;
        IProject pro = this.getSTEMProjects().get(this.projectCombo.getSelectionIndex());
        String projectPath = pro.getFullPath().toPortableString();
        String filePath = this.resourceNameField.getText();
        IPath path = new Path(TextProcessor.deprocess((String)(String.valueOf(projectPath) + "/graphs/" + filePath))).makeAbsolute();
        if (path.getFileExtension() == null) {
            path = path.addFileExtension("graph");
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)GraphEditorMessages.getString("replaceFile"), (Object)path.toString());
            MessageDialog d = new MessageDialog(this.getShell(), "Question", null, question, 3, buttons, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    this.cancelPressed();
                    return;
                }
            }
        }
        this.result = path;
        this.close();
    }

    protected boolean isResizable() {
        return true;
    }

    private void initializeProjectCombo(Combo projectCombo) {
        IProject selectedProject = this.getWorkSpaceSelectedProject();
        if (selectedProject == null) {
            selectedProject = this.getSTEMProjects().get(0);
        }
        int index = 0;
        int i = 0;
        for (IProject project : this.getSTEMProjects()) {
            if (project.equals((Object)selectedProject)) {
                index = i;
            }
            String projectName = project.getName();
            projectCombo.add(projectName);
            ++i;
        }
        projectCombo.setFocus();
        projectCombo.select(index);
    }

    private List<IProject> getSTEMProjects() {
        List stemProjects = Utility.getSTEMProjectsFromWorkspace();
        return stemProjects;
    }

    private IProject getWorkSpaceSelectedProject() {
        IProject retValue = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                if (obj instanceof IProject) {
                    retValue = (IProject)obj;
                    break;
                }
                if (obj instanceof IResource) {
                    retValue = ((IResource)obj).getProject();
                    break;
                }
                if (obj instanceof Identifiable) {
                    Path path = new Path(((Identifiable)obj).getURI().toPlatformString(true));
                    retValue = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
                    break;
                }
                if (!(obj instanceof IdentifiableTreeNode)) continue;
                retValue = ((IdentifiableTreeNode)obj).getProject();
                break;
            }
        }
        return retValue;
    }
}

