/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.forcing.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.forcing.ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class ForcingDiseaseModelImpl
extends SIRImpl
implements ForcingDiseaseModel {
    protected static final double MODULATION_EXPONENT_EDEFAULT = 2.0;
    protected double modulationExponent = 2.0;
    protected static final double MODULATION_PERIOD_EDEFAULT = 365.256363051;
    protected double modulationPeriod = 365.256363051;
    protected static final double MODULATION_PHASE_SHIFT_EDEFAULT = 0.0;
    protected double modulationPhaseShift = 0.0;
    protected static final double MODULATION_FLOOR_EDEFAULT = 0.6;
    protected double modulationFloor = 0.6;

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double seasonalModulationExponent = this.getModulationExponent();
            double seasonalModulationFloor = this.getModulationFloor();
            double modulationPeriod = this.getModulationPeriod();
            double phase = this.getModulationPhaseShift();
            double adjustedPeriod = modulationPeriod * ((double)this.getTimePeriod() / (double)timeDelta);
            double adjustedPhase = phase * ((double)this.getTimePeriod() / (double)timeDelta);
            double modulation = seasonalModulationFloor + (1.0 - seasonalModulationFloor) * Math.pow(1.0 + Math.sin(Math.PI * 2 * (t + adjustedPhase) / adjustedPeriod), seasonalModulationExponent);
            double transmissionRate = modulation * adjustedTransmissionRate;
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSIR.getS() * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)siExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    protected EClass eStaticClass() {
        return ForcingPackage.Literals.FORCING_DISEASE_MODEL;
    }

    @Override
    public double getModulationExponent() {
        return this.modulationExponent;
    }

    @Override
    public void setModulationExponent(double newModulationExponent) {
        this.modulationExponent = newModulationExponent;
    }

    @Override
    public double getModulationPeriod() {
        return this.modulationPeriod;
    }

    @Override
    public void setModulationPeriod(double newModulationPeriod) {
        this.modulationPeriod = newModulationPeriod;
    }

    @Override
    public double getModulationPhaseShift() {
        return this.modulationPhaseShift;
    }

    @Override
    public void setModulationPhaseShift(double newModulationPhaseShift) {
        this.modulationPhaseShift = newModulationPhaseShift;
    }

    @Override
    public double getModulationFloor() {
        return this.modulationFloor;
    }

    @Override
    public void setModulationFloor(double newModulationFloor) {
        this.modulationFloor = newModulationFloor;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 24: {
                return this.getModulationExponent();
            }
            case 25: {
                return this.getModulationPeriod();
            }
            case 26: {
                return this.getModulationPhaseShift();
            }
            case 27: {
                return this.getModulationFloor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 24: {
                this.setModulationExponent((Double)newValue);
                return;
            }
            case 25: {
                this.setModulationPeriod((Double)newValue);
                return;
            }
            case 26: {
                this.setModulationPhaseShift((Double)newValue);
                return;
            }
            case 27: {
                this.setModulationFloor((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 24: {
                this.setModulationExponent(2.0);
                return;
            }
            case 25: {
                this.setModulationPeriod(365.256363051);
                return;
            }
            case 26: {
                this.setModulationPhaseShift(0.0);
                return;
            }
            case 27: {
                this.setModulationFloor(0.6);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 24: {
                return this.modulationExponent != 2.0;
            }
            case 25: {
                return this.modulationPeriod != 365.256363051;
            }
            case 26: {
                return this.modulationPhaseShift != 0.0;
            }
            case 27: {
                return this.modulationFloor != 0.6;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (modulationExponent: ");
        result.append(this.modulationExponent);
        result.append(", modulationPeriod: ");
        result.append(this.modulationPeriod);
        result.append(", modulationPhaseShift: ");
        result.append(this.modulationPhaseShift);
        result.append(", modulationFloor: ");
        result.append(this.modulationFloor);
        result.append(')');
        return result.toString();
    }
}

