/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.util.StandardAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.populationmodels.preferences.PreferenceInitializer;
import org.eclipse.ui.IStartup;

public class StandardRelativeValueProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory,
IStartup {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static StandardItemProviderAdapterFactory itemProviderFactory;

    public StandardRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createStandardPopulationModelLabelAdapter() {
        return new StandardPopulationModelLabelRelativeValueProvider();
    }

    public Adapter createStandardPopulationModelLabelValueAdapter() {
        return new PopulationModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return type == RelativeValueProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public void earlyStartup() {
    }

    public static class PopulationModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> retValue = new ArrayList<IItemPropertyDescriptor>();
            StandardItemProviderAdapterFactory itemProviderFactory = StandardRelativeValueProviderAdapterFactory.getItemProviderFactory();
            PopulationModelLabelValue popv = (PopulationModelLabelValue)this.getTarget();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)popv, PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor descriptor : properties) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                retValue.add(descriptor);
            }
            return retValue;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            if (feature == null) {
                return 0.0;
            }
            StandardPopulationModelLabelValue popv = (StandardPopulationModelLabelValue)this.getTarget();
            Object obj = null;
            if (popv != null) {
                obj = popv.eGet(feature);
            }
            double retValue = 0.0;
            if (obj != null) {
                double count = (Double)obj;
                String _popRef = Activator.getDefault().getPluginPreferences().getString("referencePopulation");
                String _densRef = Activator.getDefault().getPluginPreferences().getString("referenceDensity");
                if (_popRef == null || _popRef.length() <= 0) {
                    _popRef = "0";
                }
                if (_densRef == null || _densRef.length() <= 0) {
                    _densRef = "0";
                }
                double popRef = Double.parseDouble(_popRef);
                double densRef = Double.parseDouble(_densRef);
                if (popRef == 0.0) {
                    popRef = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
                }
                if (densRef == 0.0) {
                    densRef = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
                }
                retValue = feature.getFeatureID() == 5 ? count / densRef : count / popRef;
            }
            return retValue;
        }

        public double getDenominator(EStructuralFeature feature) {
            long popRef = Activator.getDefault().getPreferenceStore().getLong("referencePopulation");
            long densRef = Activator.getDefault().getPreferenceStore().getLong("referenceDensity");
            if (popRef == 0L) {
                popRef = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
            }
            if (densRef == 0L) {
                popRef = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
            }
            if (feature.getFeatureID() == 5) {
                return densRef;
            }
            return popRef;
        }
    }

    public static class StandardPopulationModelLabelRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            PopulationModelLabel pop = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)pop.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            PopulationModelLabel pop = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)pop.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            String _popRef = Activator.getDefault().getPluginPreferences().getString("referencePopulation");
            String _densRef = Activator.getDefault().getPluginPreferences().getString("referenceDensity");
            double popRef = Double.parseDouble(_popRef);
            double densRef = Double.parseDouble(_densRef);
            if (popRef == 0.0) {
                popRef = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
            }
            if (densRef == 0.0) {
                popRef = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
            }
            if (feature != null && feature.getFeatureID() == 5) {
                return densRef;
            }
            return popRef;
        }
    }
}

