/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class EstimatorCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    static ColorDefinition[] barColors = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.PINK(), ColorDefinitionImpl.BLACK()};
    private static final String TITLE = "Estimated Parameters";
    private static final String VALUES = "Parameter Values";
    private static final String VALUES_LOWER = "Value - Std.Dev.";
    private static final String VALUES_HIGHER = "Value + Std.Dev.";
    private static final boolean SHOW_STD_DEV = false;
    private static Vector<String> xAxisParameterNames = new Vector();
    private static ArrayList<Double> barValues = new ArrayList();
    private static NumberDataSet barOrthoValues;
    private static ArrayList<Double> barStdDevLower;
    private static ArrayList<Double> barStdDevHigher;
    private static NumberDataSet barOrthoStdDevLower;
    private static NumberDataSet barOrthoStdDevHigher;
    Generator gr = Generator.instance();
    Image imgChart = null;

    static {
        barStdDevLower = new ArrayList();
        barStdDevHigher = new ArrayList();
    }

    public EstimatorCanvas(Composite parent) {
        super(parent, 0x20000800);
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        Vector<String> xAxisParameters = new Vector<String>();
        xAxisParameters.add("beta");
        xAxisParameters.add("alpha");
        xAxisParameters.add("epsilon");
        xAxisParameters.add("gamma");
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                if (EstimatorCanvas.this.cm == null) {
                    return;
                }
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (EstimatorCanvas.this.imgChart != null) {
                    EstimatorCanvas.this.imgChart.dispose();
                }
                EstimatorCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                EstimatorCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)EstimatorCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)EstimatorCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    EstimatorCanvas.this.gr.render(EstimatorCanvas.this.idr, EstimatorCanvas.this.gr.build(EstimatorCanvas.this.idr.getDisplayServer(), EstimatorCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(EstimatorCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
    }

    public static Chart createBarChart(Map<String, Parameter> barDataMap) {
        xAxisParameterNames.clear();
        barValues.clear();
        barStdDevLower.clear();
        barStdDevHigher.clear();
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaBar.getBlock().getOutline().setVisible(true);
        cwaBar.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        Plot p = cwaBar.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        p.getOutline().setVisible(false);
        cwaBar.getTitle().getLabel().getCaption().setValue(TITLE);
        Legend lg = cwaBar.getLegend();
        lg.getText().getFont().setSize(16.0f);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.setAnchor(Anchor.NORTH_LITERAL);
        Axis xAxisPrimary = cwaBar.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getTitle().setVisible(false);
        Axis yAxisPrimary = cwaBar.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getLabel().getCaption().getFont().setRotation(90.0);
        Set<String> keySet = barDataMap.keySet();
        Object[] keys = new String[keySet.size()];
        Iterator<String> iter = keySet.iterator();
        int icount = 0;
        while (iter.hasNext()) {
            keys[icount] = iter.next();
            ++icount;
        }
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object paramName = keys[i];
            xAxisParameterNames.add((String)paramName);
            Double dValue = barDataMap.get((Object)paramName).value;
            barStdDevLower.add(dValue);
            barValues.add(dValue);
            barStdDevHigher.add(dValue);
            ++i;
        }
        TextDataSet categoryValues = TextDataSetImpl.create(xAxisParameterNames);
        barOrthoValues = NumberDataSetImpl.create(barValues);
        barOrthoStdDevLower = NumberDataSetImpl.create(barStdDevLower);
        barOrthoStdDevHigher = NumberDataSetImpl.create(barStdDevHigher);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        BarSeries bsLower = (BarSeries)BarSeriesImpl.create();
        bsLower.setSeriesIdentifier((Object)VALUES_LOWER);
        bsLower.setDataSet((DataSet)barOrthoStdDevLower);
        bsLower.setRiserOutline(null);
        bsLower.getLabel().setVisible(true);
        bsLower.setLabelPosition(Position.INSIDE_LITERAL);
        BarSeries bsValues = (BarSeries)BarSeriesImpl.create();
        bsValues.setSeriesIdentifier((Object)VALUES);
        bsValues.setDataSet((DataSet)barOrthoValues);
        bsValues.setRiserOutline(null);
        bsValues.getLabel().setVisible(true);
        bsValues.setLabelPosition(Position.INSIDE_LITERAL);
        BarSeries bsHigher = (BarSeries)BarSeriesImpl.create();
        bsHigher.setSeriesIdentifier((Object)VALUES_HIGHER);
        bsHigher.setDataSet((DataSet)barOrthoStdDevHigher);
        bsHigher.setRiserOutline(null);
        bsHigher.getLabel().setVisible(true);
        bsHigher.setLabelPosition(Position.INSIDE_LITERAL);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().update(0);
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        SeriesDefinition sdY1 = SeriesDefinitionImpl.create();
        sdY1.getSeriesPalette().update(1);
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY1);
        sdY1.getSeries().add((Object)bsValues);
        return cwaBar;
    }

    public static void refresh(Map<String, Parameter> barDataMap) {
        for (Map.Entry<String, Parameter> entry : barDataMap.entrySet()) {
            int icount = xAxisParameterNames.indexOf(entry.getKey());
            if (icount < 0) continue;
            double value = entry.getValue().value;
            double deviation = entry.getValue().stddev;
            Double lower = value - deviation;
            Double higher = value + deviation;
            barValues.set(icount, value);
            barStdDevLower.set(icount, lower);
            barStdDevHigher.set(icount, higher);
        }
    }

    public void draw(Map<String, Parameter> barDataMap) {
        this.cm = EstimatorCanvas.createBarChart(barDataMap);
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void dispose() {
        super.dispose();
    }
}

