/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

public abstract class ParameterEstimator {
    protected static final String keyS = "S";
    protected static final String keyE = "E";
    protected static final String keyI = "I";
    protected static final String keyR = "R";
    protected static final String keySelectedS = "S*";
    protected static final String keySelectedE = "E*";
    protected static final String keySelectedI = "I*";
    protected static final String keySelectedR = "R*";
    protected static final String keyXY1 = "X1vsY1";
    protected static final String keyXY2 = "X2vsY2";
    protected static final String keyXY3 = "X3vsY3";
    protected static final String keyXY4 = "X4vsY4";
    protected static final String keyFit1 = "Fit XY1";
    protected static final String keyFit2 = "Fit XY2";
    protected static final String keyFit3 = "Fit XY3";
    protected static final String keyFit4 = "Fit XY4";
    protected static double minSthreshold = 0.01;
    protected static double minEthreshold = 0.01;
    protected static double minIthreshold = 0.01;
    protected static double minRthreshold = 0.01;
    protected static double maxSthreshold = 0.99;
    protected static double maxEthreshold = 0.99;
    protected static double maxIthreshold = 0.99;
    protected static double maxRthreshold = 0.99;
    protected static boolean useFreqDependantBeta = true;
    protected double rejectCount = 0.0;
    List<double[][]> dataToPlot = new ArrayList<double[][]>();
    List<double[][]> regressionValues = new ArrayList<double[][]>();
    List<double[][]> fittedValues = new ArrayList<double[][]>();
    protected ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data;
    protected static final int MINSIZE = 7;
    public static final int LINEAR_DERIVATIVE = 1;
    public static final int POLYNOMIAL_DERIVATIVE = 2;
    double[] p;
    double[] s;
    double[] i;
    double[] t;
    public boolean dataValid = false;
    int numDataPoints;

    public ParameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        this.data = data;
        this.data.findMaxValues();
    }

    public abstract int getNumProperties();

    public String getProperty(int equationIndex, int state) {
        switch (equationIndex) {
            case 0: {
                if (state == 0) {
                    return keyS;
                }
                if (state == 1) {
                    return keySelectedS;
                }
                if (state == 2 || state == 3) {
                    return keyXY1;
                }
                return keyFit1;
            }
            case 1: {
                if (state == 0) {
                    return keyI;
                }
                if (state == 1) {
                    return keySelectedI;
                }
                if (state == 2 || state == 3) {
                    return keyXY2;
                }
                return keyFit2;
            }
            case 2: {
                if (state == 0) {
                    return keyR;
                }
                if (state == 1) {
                    return keySelectedR;
                }
                if (state == 2 || state == 3) {
                    return keyXY3;
                }
                return keyFit3;
            }
            case 3: {
                if (state == 0) {
                    return keyE;
                }
                if (state == 1) {
                    return keySelectedE;
                }
                if (state == 2 || state == 3) {
                    return keyXY4;
                }
                return keyFit4;
            }
        }
        return null;
    }

    public void setAllParameters(Map<String, Object> controlParametersMap) {
        if (controlParametersMap != null) {
            maxSthreshold = (Double)controlParametersMap.get("MAXS");
            minSthreshold = (Double)controlParametersMap.get("MINS");
            maxEthreshold = (Double)controlParametersMap.get("MAXE");
            minEthreshold = (Double)controlParametersMap.get("MINE");
            maxIthreshold = (Double)controlParametersMap.get("MAXI");
            minIthreshold = (Double)controlParametersMap.get("MINI");
            maxRthreshold = (Double)controlParametersMap.get("MAXR");
            minRthreshold = (Double)controlParametersMap.get("MINR");
            useFreqDependantBeta = (Boolean)controlParametersMap.get("FREQ_MODE");
        }
    }

    public abstract ModelParameters estimate(double var1, double var3, String var5);

    public double[] getValues(int chartIndex, int state) {
        if (state <= 1) {
            double[][] data = this.dataToPlot.get(chartIndex);
            return data[state];
        }
        double[][] regression = this.regressionValues.get(chartIndex);
        return regression[state - 2];
    }

    public double[][] getSortedRegression(List<Double> xList, List<Double> yList) {
        double[][] regression = new double[2][xList.size()];
        if (yList.size() != xList.size()) {
            return regression;
        }
        ArrayList<PhaseSpaceCoordinate> coords = new ArrayList<PhaseSpaceCoordinate>();
        int i = 0;
        while (i < xList.size()) {
            double x = xList.get(i);
            double y = yList.get(i);
            PhaseSpaceCoordinate coord = new PhaseSpaceCoordinate(x, y);
            coords.add(coord);
            ++i;
        }
        Object[] coordArray = coords.toArray();
        Arrays.sort(coordArray);
        int i2 = 0;
        while (i2 < xList.size()) {
            PhaseSpaceCoordinate coord = (PhaseSpaceCoordinate)coordArray[i2];
            regression[0][i2] = coord.xValue;
            regression[1][i2] = coord.yValue;
            ++i2;
        }
        return regression;
    }
}

