/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.ResourceSetReferencingResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ResourceSetReferencingResourceSetImpl
extends XtextResourceSet
implements ResourceSetReferencingResourceSet {
    private final List<ResourceSet> referencedResourceSets = new ArrayList<ResourceSet>();

    @Override
    public List<ResourceSet> getReferencedResourceSets() {
        return this.referencedResourceSets;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        return resource.getEObject(uri.fragment());
    }

    @Override
    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource = this.findResourceInResourceSet(uri, this);
        Iterator<ResourceSet> iterator = this.referencedResourceSets.iterator();
        while (resource == null && iterator.hasNext()) {
            resource = this.findResourceInResourceSet(uri, iterator.next());
        }
        if (resource != null) {
            return this.load(resource, loadOnDemand);
        }
        return super.getResource(uri, loadOnDemand);
    }

    private Resource findResourceInResourceSet(URI uri, ResourceSet set) {
        EList resources = set.getResources();
        for (Resource resource : resources) {
            if (!resource.getURI().equals(uri)) continue;
            return resource;
        }
        return null;
    }

    private Resource load(Resource resource, boolean loadOnDemand) {
        if (!loadOnDemand) {
            try {
                resource.load(resource.getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
        return resource;
    }
}

