/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredTypeResourceDescription
implements IResourceDescription {
    private final TypeResourceDescription delegate;
    private final List<IEObjectDescription> additionallyExported;

    public LayeredTypeResourceDescription(TypeResourceDescription delegate, List<IEObjectDescription> additionallyExported) {
        this.delegate = delegate;
        this.additionallyExported = additionallyExported;
    }

    public Iterable<QualifiedName> getImportedNames() {
        return this.delegate.getImportedNames();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.delegate.getReferenceDescriptions();
    }

    public URI getURI() {
        return this.delegate.getURI();
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        return Iterables.concat((Iterable)this.delegate.getExportedObjects(), this.additionallyExported);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty() && this.additionallyExported.isEmpty();
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(final EClass type) {
        Iterable additionallyFiltered = Iterables.filter(this.additionallyExported, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom((EClass)type, (EClass)input.getEClass());
            }
        });
        return Iterables.concat((Iterable)this.delegate.getExportedObjectsByType(type), (Iterable)additionallyFiltered);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(final EObject object) {
        final URI uri = EcoreUtil2.getNormalizedURI((EObject)object);
        Iterable additionallyFiltered = Iterables.filter(this.getExportedObjects(), (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return true;
                }
                return uri.equals((Object)input.getEObjectURI());
            }
        });
        return Iterables.concat((Iterable)this.delegate.getExportedObjectsByObject(object), (Iterable)additionallyFiltered);
    }

    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName name, boolean ignoreCase) {
        Object predicate = ignoreCase ? new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return EcoreUtil2.isAssignableFrom((EClass)type, (EClass)input.getEClass());
            }
        } : new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return name.equals((Object)input.getName()) && EcoreUtil2.isAssignableFrom((EClass)type, (EClass)input.getEClass());
            }
        };
        Iterable additionallyFiltered = Iterables.filter(this.getExportedObjects(), (Predicate)predicate);
        return Iterables.concat((Iterable)this.delegate.getExportedObjects(type, name, ignoreCase), (Iterable)additionallyFiltered);
    }
}

