/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.views.graphmap.StemPolygon;

public class StemPolygonList
extends ArrayList<StemPolygon> {
    private static final long serialVersionUID = 1L;

    public StemPolygonList() {
    }

    public StemPolygonList(LatLong latLongData, Identifiable identifiable) {
        for (LatLong.Segment latLongSegment : latLongData.getSegments()) {
            this.add(new StemPolygon(latLongSegment, identifiable));
        }
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = null;
        for (StemPolygon polygon : this) {
            if (polygon.getIdentifiable() instanceof Edge) continue;
            bounds = bounds != null ? (Rectangle2D.Double)bounds.createUnion(polygon.getBounds()) : polygon.getBounds();
        }
        return bounds;
    }

    public StemPolygon getContainingRegionPolygon(Point2D.Double latLongPosition) {
        StemPolygon polygon = null;
        double minArea = Double.POSITIVE_INFINITY;
        for (StemPolygon p : this) {
            if (!(p.getIdentifiable() instanceof Region) || !p.containsPoint(latLongPosition) || !(p.getArea() < minArea)) continue;
            polygon = p;
            minArea = p.getArea();
        }
        return polygon;
    }

    public void setValueToDisplay(double valueToDisplay) {
        for (StemPolygon p : this) {
            p.setValueToDisplay(valueToDisplay);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StemPolygonList)) {
            return false;
        }
        StemPolygonList list = (StemPolygonList)o;
        int n = this.size();
        if (n != list.size()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            URI uri2;
            URI uri1 = ((StemPolygon)this.get(i)).getIdentifiable().getURI();
            if (!uri1.equals((Object)(uri2 = ((StemPolygon)list.get(i)).getIdentifiable().getURI()))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

