/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorsLegendComposite
extends Composite {
    Group legendGroup = new Group((Composite)this, 0);

    public ColorsLegendComposite(Composite parent, int style) {
        super(parent, style);
        this.legendGroup.setText("Colors Legend");
        GridLayout legendLayout = new GridLayout();
        legendLayout.numColumns = 4;
        legendLayout.horizontalSpacing = 10;
        legendLayout.verticalSpacing = 2;
        legendLayout.makeColumnsEqualWidth = false;
        legendLayout.marginBottom = 15;
        this.legendGroup.setLayout((Layout)legendLayout);
    }

    public void addColorEntry(String colorID, String text) {
        Color color = this.getPreferencesColor(colorID);
        Label colorLabel = new Label((Composite)this.legendGroup, 2048);
        colorLabel.setBackground(color);
        colorLabel.setText("            ");
        Label colorText = new Label((Composite)this.legendGroup, 0);
        colorText.setText(text);
        this.legendGroup.pack();
        this.layout();
    }

    private Color getPreferencesColor(String colorId) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String color = preferenceStore.getString(colorId);
        RGB rgb = StringConverter.asRGB((String)color);
        return new Color((Device)this.getDisplay(), rgb.red, rgb.green, rgb.blue);
    }
}

