/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.NodeLabel;

public class Utility {
    public static final String DECORATORS_FOLDER_NAME = "decorators";
    private static final String HUMAN_POPULATION_PLUGIN_ID = "org.eclipse.stem.data.geography.population.human";
    private static final String GEOGRAPHY_DATA_PLUGIN_ID = "org.eclipse.stem.data.geography";

    public static List<IProject> getSTEMProjectsFromWorkspace() {
        return Utility.getSTEMProjectsFromWorkspace(ResourcesPlugin.getWorkspace());
    }

    public static List<IProject> getSTEMProjectsFromWorkspace(IWorkspace workspace) {
        IProject[] projects;
        ArrayList<IProject> retValue = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (Utility.isSTEMProject(project)) {
                retValue.add(project);
            }
            ++n2;
        }
        return retValue;
    }

    public static boolean isSTEMProject(IProject project) {
        boolean retValue = false;
        try {
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (nature.equals("org.eclipse.stem.stemnature")) {
                    retValue = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            retValue = false;
        }
        return retValue;
    }

    public static Identifiable getIdentifiable(IFile file) {
        URI fileURI = URI.createFileURI((String)file.getLocation().toString());
        return org.eclipse.stem.core.Utility.getIdentifiable((URI)fileURI);
    }

    public static Identifiable getIdentifiableIgnoreException(IFile file) {
        URI fileURI = URI.createFileURI((String)file.getLocation().toString());
        return org.eclipse.stem.core.Utility.getIdentifiableIgnoreException((URI)fileURI);
    }

    public static Label getLabel(URI labelURI) {
        NodeLabel retValue = null;
        if (Utility.isAreaLabel(labelURI)) {
            URI areaGraphURI = Utility.createAreaGraphURI(labelURI);
            Graph areaGraph = (Graph)org.eclipse.stem.core.Utility.getIdentifiable((URI)areaGraphURI);
            retValue = areaGraph.getNodeLabel(labelURI);
        } else if (Utility.isPopulationLabel(labelURI)) {
            URI populationGraphURI = Utility.createPopulationGraphURI(labelURI);
            Graph populationGraph = (Graph)org.eclipse.stem.core.Utility.getIdentifiable((URI)populationGraphURI);
            retValue = populationGraph.getNodeLabel(labelURI);
        }
        return retValue;
    }

    private static boolean isAreaLabel(URI labelURI) {
        return Utility.extractLabelName(labelURI.toString()).equals("area");
    }

    private static boolean isPopulationLabel(URI labelURI) {
        return Utility.extractLabelName(labelURI.toString()).equals("population");
    }

    private static URI createAreaGraphURI(URI labelURI) {
        String prefix = URI.createPlatformPluginURI((String)GEOGRAPHY_DATA_PLUGIN_ID, (boolean)false).toString();
        StringBuilder sb = new StringBuilder(String.valueOf(prefix) + "/resources/data");
        sb.append("/country/");
        String uriString = labelURI.toString();
        String labelName = Utility.extractLabelName(uriString);
        String isoKey = Utility.extractISOKey(uriString, labelName);
        String level = Utility.extractISOLevel(uriString, isoKey);
        sb.append(isoKey);
        sb.append("/");
        String fileName = Utility.createAreaGraphFileName(isoKey, level, labelName);
        sb.append(fileName);
        return URI.createURI((String)sb.toString());
    }

    public static URI createPopulationGraphURI(URI labelURI) {
        String prefix = URI.createPlatformPluginURI((String)HUMAN_POPULATION_PLUGIN_ID, (boolean)false).toString();
        StringBuilder sb = new StringBuilder(String.valueOf(prefix) + "/resources/data");
        sb.append("/country/");
        String uriString = labelURI.toString();
        String labelName = Utility.extractLabelName(uriString);
        String isoKey = Utility.extractISOKey(uriString, labelName);
        String level = Utility.extractISOLevel(uriString, isoKey);
        String populationName = Utility.extractPopulationName(uriString, level);
        String date = Utility.extractPopulationDate(uriString, populationName);
        sb.append(isoKey);
        sb.append("/");
        sb.append(Utility.createPopulationGraphFileName(isoKey, level, labelName, populationName, date));
        return URI.createURI((String)sb.toString());
    }

    private static String extractPopulationDate(String uriString, String populationName) {
        int index = uriString.indexOf(populationName);
        String temp = uriString.substring(index + populationName.length() + 1);
        int index2 = temp.indexOf("/");
        return temp.substring(0, index2);
    }

    private static String createPopulationGraphFileName(String isoKey, String level, String labelName, String populationName, String date) {
        StringBuilder sb = new StringBuilder(isoKey);
        sb.append("_");
        sb.append(level);
        sb.append("_");
        sb.append(populationName);
        sb.append("_");
        sb.append(date);
        sb.append("_");
        sb.append("population.graph");
        return sb.toString();
    }

    private static String extractPopulationName(String uriString, String level) {
        int index = uriString.indexOf(level);
        String temp = uriString.substring(index + level.length() + 1);
        int index2 = temp.indexOf("/");
        return temp.substring(0, index2);
    }

    private static String extractISOLevel(String uriString, String isoKey) {
        int index = uriString.indexOf(isoKey) + isoKey.length() + 1;
        return uriString.substring(index, index + 1);
    }

    private static String createAreaGraphFileName(String isoKey, String level, String labelName) {
        StringBuilder sb = new StringBuilder(isoKey);
        sb.append("_");
        sb.append(level);
        sb.append("_");
        sb.append(labelName);
        sb.append(".graph");
        return sb.toString();
    }

    private static String extractISOKey(String uriString, String labelName) {
        int startIndex = uriString.indexOf(labelName) + 1 + labelName.length();
        int endIndex = startIndex + 3;
        return uriString.substring(startIndex, endIndex);
    }

    private static String extractLabelName(String uriString) {
        String uriSuffix = uriString.substring(uriString.indexOf("label") + "label".length() + 1);
        return uriSuffix.substring(0, uriSuffix.indexOf("/"));
    }
}

