/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen.xtext;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.codegen.STEMGenFeature;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.resource.XtextResource;

public abstract class ModelExpressionGenerator
implements IGenerator {
    protected ImportManager importManager;
    protected GenClass modelGenClass;
    protected GenClass labelGenClass;
    protected GenClass labelValueGenClass;

    public abstract void doGenerate(List<XtextResource> var1, IFileSystemAccess var2);

    public GenClass getModelGenClass() {
        return this.modelGenClass;
    }

    public void setModelGenClass(GenClass modelGenClass) {
        this.modelGenClass = modelGenClass;
    }

    public GenClass getLabelGenClass() {
        return this.labelGenClass;
    }

    public void setLabelGenClass(GenClass labelGenClass) {
        this.labelGenClass = labelGenClass;
    }

    public GenClass getLabelValueGenClass() {
        return this.labelValueGenClass;
    }

    public void setLabelValueGenClass(GenClass labelValueGenClass) {
        this.labelValueGenClass = labelValueGenClass;
    }

    public void setImportManager(ImportManager manager) {
        this.importManager = manager;
    }

    public String importGenClassInterface(GenClass gc) {
        String interfacePackage = gc.getGenPackage().getInterfacePackageName();
        String interfaceName = gc.getName();
        return this.getImportedName(String.valueOf(interfacePackage) + "." + interfaceName);
    }

    public String getFormattedName(Transition transition) {
        return String.valueOf(transition.getSource().getName()) + " -> " + transition.getTarget().getName();
    }

    public String getMethodName(Transition transition) {
        return String.valueOf(transition.getSource().getName()) + "_" + transition.getTarget().getName();
    }

    public GenFeature getGenFeature(Compartment compartment) {
        STEMGenClass gc = STEMGenClass.get(this.labelValueGenClass);
        for (STEMGenFeature stemGF : gc.getAllCompartmentFeatures()) {
            GenFeature genFeature = stemGF.getGenFeature();
            if (!genFeature.getName().equals(compartment.getName())) continue;
            return genFeature;
        }
        return null;
    }

    public String getPackageAccessorName(GenFeature feature) {
        if (feature != null) {
            GenPackage featureGenPackage = feature.getGenPackage();
            String packageImportedName = this.getImportedName(String.valueOf(featureGenPackage.getReflectionPackageName()) + "." + featureGenPackage.getPackageInterfaceName());
            String accessor = String.valueOf(packageImportedName) + ".eINSTANCE.get" + feature.getFeatureAccessorName() + "()";
            return accessor;
        }
        return "null";
    }

    public String getImportedName(String qualifiedName) {
        return this.importManager.getImportedName(qualifiedName, true);
    }

    public String getSortedImports() {
        return this.importManager.computeSortedImports();
    }

    protected String getAccessorName(Compartment compartment) {
        return GeneratorUtils.formatToUpperCaseWordsNoSpaces(compartment.getName());
    }

    protected Set<Compartment> getAffectedCompartments(List<XtextResource> resources) {
        HashSet<Compartment> compartments = new HashSet<Compartment>();
        for (XtextResource resource : resources) {
            if (!(resource instanceof ContextSensitiveResourceWrapper)) continue;
            Transition transition = ((ContextSensitiveResourceWrapper)resource).getTransition();
            compartments.add(transition.getSource());
            compartments.add(transition.getTarget());
            for (Compartment incidence : transition.getForIncidence()) {
                compartments.add(incidence);
            }
        }
        return compartments;
    }
}

